
#__author__ = "Chris Maidens"
#__copyright__ = "Copyright (C) 2020 Chris Maidens"
#__license__ = "No license granted"
#__version__ = "0.1"
import os

import MAFpt_r_params as rpar

import MAFpt_ATTACK_DB_v2 as ATTACK

YAML_Root = os.environ.get('MAFpt_YAML_ROOT')
YAML_File = os.environ.get('MAFpt_YAML_FILE')
YAML_File="MAFpt_RunParams.yaml"

YAML_Root = os.getcwd()
YAML_File="/MAFpt_ATTACK_DB_TEST_RunParams.yaml"

p_obj = rpar.MAFpt_r_params(YAML_Root + YAML_File)

DOWNLOAD_ATTACK=p_obj.MAFpt_r_read("RUN_DOWNLOAD_ATTACK")
REINDEX_ATTACK=p_obj.MAFpt_r_read("RUN_REINDEX_ATTACK")
ATTACK_LOCAL_FILE_ROOT = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_FILE_ROOT')
ATTACK_TAXII_SERVER = p_obj.MAFpt_r_read('RUN_ATTACK_TAXII_SERVER')
ATTACK_LOCAL_COPY = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_COPY')
ATTACK_CVE_SEARCH = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_SEARCH')
ATTACK_MAIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_MAIN_INDEX')
ATTACK_SUB_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_SUB_INDEX')
ATTACK_CVE_REF_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_REF_INDEX')
ATTACK_TTP_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_INDEX')
ATTACK_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_INDEX')
ATTACK_TECH_TO_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TECH_TO_TACTIC_INDEX')
ATTACK_REL_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_REL_INDEX')    
ATTACK_TACTIC_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_BIN_INDEX')   
ATTACK_TTP_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_BIN_INDEX') 

ATTACK_obj = ATTACK.MAFpt_ATTACK_DB(DOWNLOAD_ATTACK,
                         ATTACK_TAXII_SERVER,
                         ATTACK_LOCAL_FILE_ROOT,
                         ATTACK_LOCAL_COPY,
                         REINDEX_ATTACK,
                         ATTACK_CVE_SEARCH, 
                         ATTACK_MAIN_INDEX, 
                         ATTACK_SUB_INDEX, 
                         ATTACK_CVE_REF_INDEX, 
                         ATTACK_TTP_INDEX, 
                         ATTACK_TACTIC_INDEX, 
                         ATTACK_TECH_TO_TACTIC_INDEX, 
                         ATTACK_REL_INDEX, 
                         ATTACK_TACTIC_BIN_INDEX, 
                         ATTACK_TTP_BIN_INDEX) 
                         
TacticBinDF=ATTACK_obj.GetTacticBinIndex()
                         

from MAFpt_ATTACK_DB_ATTACK_GRAPHS_DATA_AUTO import ThisAttackTechList 

ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001',  'Ajax_Security_Team_001',  'Andariel_001',  'APT38_001',  'ZAPT33_001', 
                           'ZAPT19_001',  'ZSandworm_002',  'ZAPT28_005',  'ZAPT32_001',  'ZAPT29_005']



#AttackSeqTacticList=[]
#AttackSeqTacticCount=[]

CHECK_LENGTH=6
FailCount=0
SuccCount=0

for ONLY_USE in ONLY_USE_LIST:
    IDList=[]
    count=0

    # Build a list of Tactic sequence pairs. They will be dicts
    T1givenT0=[]

    # Build a list of Tactic Technique (O) pairs. They will be dicts
    TNON=[]

    # This loop extracts the required pairs from the example Attack (ONLY_USE)
    #ONLY_USE=['ZAPT33_001']
    for ThisAttack in ThisAttackTechList:
        IDLine=True
        PrevTactic=""
        CheckedLength=0
        for NextNode in ThisAttack:
        
            if IDLine==True:
                if not NextNode['ID'] in ONLY_USE:
                    break
                IDLine=False
                IDList.append(NextNode["ID"])
                count+=1
            
            else:
                if NextNode['SG'] == 'G':
                    continue
                # Allow some control over how much of the attack is checked
                # Stop checking when limit reached
                CheckedLength+=1
                if CheckedLength > CHECK_LENGTH:
                    continue
                #print("The Tactic is " + NextNode['Tactic'])
                Tactic=NextNode['Tactic']
                if PrevTactic=="":
                    PrevTactic=Tactic
                else:
                    T1givenT0_Dict={'Prev':PrevTactic, 'This':Tactic}
                    
                    InList=False
                    for NextDict in T1givenT0:
                        if NextDict == T1givenT0_Dict:
                            InList=True
                
                    if InList == False:
                        T1givenT0.append(T1givenT0_Dict)
                    #print("Appending " + str(T1givenT0_Dict))
                
                    PrevTactic=Tactic
                 # Check Tactic OK
                TacticName=ATTACK_obj.GetTacticName(Tactic)
            
                TTP=NextNode['Tech']

                Parent_Text=""

                if "." in TTP:
                    Parent=ATTACK_obj.GetTechForSub(TTP)
                    TTPDict=ATTACK_obj.GetTTPDetails(Parent)
                    Parent_Text=TTPDict['TTP_Name']

                TTPDict=ATTACK_obj.GetTTPDetails(TTP)

                #print("Technique name for " + TTP + " : " + Parent_Text + " : " +TTPDict['TTP_Name'])
            
            
                TNON_Dict={'Tactic':Tactic, 'Tech':TTP}
            
                InList=False
                for NextDict in TNON:
                    if NextDict == TNON_Dict:
                        InList=True
                if InList == False:
                    TNON.append(TNON_Dict)
            
    print("Processed list is " + str(IDList))
    #print("TNON " + str(TNON))
    #print("T1givenT0 " + str(T1givenT0))
    #print("The Tac Tech pairs recorded are " + str(TNON))

    #for NextTNONDict in TNON:
        #print("The next Tact/Tech pair is " + NextTNONDict['Tactic'] + " / " + NextTNONDict['Tech'])
    
    # This loop looks for the required pairs in the whole database
    IDCKList=[]
    count=0
    TNONFound=[0]*len(TNON)
    T1givenT0Found=[0]*len(T1givenT0)
    CHECK_LENGTH=6
   

    for ThisAttack in ThisAttackTechList:
        IDLine=True
        AttackName=""
        PrevTactic=""
        CheckedLength=0
        for NextNode in ThisAttack:
        
            if IDLine==True:
                # This time ignore the attack being checked
                if NextNode['ID'] in ONLY_USE:
                    break
                AttackName=NextNode["ID"]
                IDLine=False
                IDCKList.append(NextNode["ID"])
                count+=1
            
            else:
                #print("Comparing with " + AttackName)
                if NextNode['SG'] == 'G':
                    continue
                # Allow some control over how much of the attack is checked
                # Stop checking when limit reached
                #CheckedLength+=1
                #if CheckedLength > CHECK_LENGTH:
                #    continue
                    
                #print("The Tactic is " + NextNode['Tactic'])
                Tactic=NextNode['Tactic']
            
                TTP=NextNode['Tech']
            
                CK_TNON_Dict={'Tactic':Tactic, 'Tech':TTP}
            
                if Tactic == "TA0011":
                    if TTP == "T1132.001":
                        print("Found TA0011/T1132.001 in " + AttackName)
                # Does this Tactic Tech pair exist in the attack being checked
                ThisID=0
                for NextPairToCheck in TNON:
                    if NextPairToCheck['Tactic'] == Tactic:
                        if NextPairToCheck['Tech'] == TTP:
                            #print("Found a match for " + Tactic + " / " + TTP + " in " + AttackName)
                            TNONFound[ThisID]=1                        
                
                    ThisID+=1
                
                # Does this Tactic Prev-This pair exist in the attack being checked
                ThisTPTID=0
                if PrevTactic=="":
                    PrevTactic=Tactic
                else:
                    for NextPairToCheck in T1givenT0:
                        if NextPairToCheck['Prev'] == PrevTactic:
                            if NextPairToCheck['This'] == Tactic:
                                #print("Found a match for " + PrevTactic + " / " + Tactic + " in " + AttackName)
                                T1givenT0Found[ThisTPTID]=1 
                            
                        ThisTPTID+=1
                
                    PrevTactic=Tactic                       
                
                

    ThisID=0  
    FailFound=False    
    for NextFlag in TNONFound:
        if NextFlag==0:
            if FailFound==False:
                FailFound=True
                FailCount+=1
            print("No Tactic Tech match found for " + str(TNON[ThisID]))
        ThisID+=1
    
    ThisID=0      
    for NextFlag in T1givenT0Found:
        if NextFlag==0:
            if FailFound==False:
                FailFound=True
                FailCount+=1
            print("No Prev/This Tactic match found for " + str(T1givenT0[ThisID]))
        ThisID+=1
    if FailFound==False:
                SuccCount+=1
                
    #break
        
print("Total success count is " + str(SuccCount))
print("Total fail count is " + str(FailCount))

