%% SMP policies ST - Length

% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.policy_20(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.policy_20(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
    if LD.policy_20 (n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'a)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.policy_20 (n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.policy_20(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
    end
    if HD.policy_20(n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length_CFP(n);
            end
        end
    end
end


set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=30;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');

lgd.NumColumns = 3;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'b)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.063767429184258         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvanta_ST_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\EPS\Disadvanta_ST_Length'); %<-Save as PDF with 300 DPI

%% SMP policies LT - Length

% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.policy_100(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.policy_100(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
    if LD.policy_100 (n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'a)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.policy_100 (n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.policy_100(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
    end
    if HD.policy_100(n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length_CFP(n);
            end
        end
    end
end


set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=30;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');

lgd.NumColumns = 3;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'b)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.063767429184258         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvanta_LT_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\EPS\Disadvanta_LT_Length'); %<-Save as PDF with 300 DPI

%% SMP policies HTL - Length

% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.policy_20(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.policy_100(n)== 'HTL'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
text(-0.15,1.07,'a)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.policy_20 (n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.policy_100(n)== 'HTL'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
     end
     
end


set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=30;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');

lgd.NumColumns = 2;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
text(-0.15,1.07,'b)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.063767429184258         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvanta_HTL_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\EPS\Disadvanta_HTL_Length'); %<-Save as PDF with 300 DPI

%% SMP policies MR - Length

% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.policy_20(n)=='MR'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.policy_100(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
text(-0.15,1.07,'c)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.policy_20 (n)=='MR'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.policy_100(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
     end
     
end


set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=30;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
% lgd= legend('Short-Term','Long-Term');
% legend('boxoff');
% legend('Location','southoutside');
% set(lgd, 'position', [0.290691064079952         0.063767429184258         0.464138741916519        0.0364705882352941]);
% lgd.NumColumns = 2;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
text(-0.15,1.07,'d)','Units','normalized', 'fontsize',15)



print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvanta_MR_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\EPS\Disadvanta_MR_Length'); %<-Save as PDF with 300 DPI

%% SMP policies NAI - Length

% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.policy_20(n)=='NAI'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.policy_100(n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
text(-0.15,1.07,'e)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.policy_20 (n)=='NAI'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.policy_100(n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
     end
     
end


set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=30;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');

lgd.NumColumns = 2;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
text(-0.15,1.07,'f)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.063767429184258         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvanta_NAI_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\EPS\Disadvanta_NAI_Length'); %<-Save as PDF with 300 DPI

%% Defences - Length

% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.Def_Type(n)=='Natural'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.Def_Type(n)== 'Engineered'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
    if LD.Def_Type (n)== 'Combo'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'a)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.Def_Type (n)=='Natural'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.Def_Type(n)== 'Engineered'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
    end
    if HD.Def_Type(n)== 'Combo'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length_CFP(n);
            end
        end
    end
end


set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=30;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');

lgd.NumColumns = 3;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'b)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.063767429184258         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvanta_Defences_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\EPS\Disadvanta_Defences_Length'); %<-Save as PDF with 300 DPI

%% Erosion - Length

% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.Erosion (n)=='Erosion'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.Erosion(n)=='Stable'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
    if LD.Erosion(n)=='Accretion'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length_CFP(n);
            end
        end
    end
end


set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'a)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.Erosion (n)=='Erosion'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.Erosion(n)=='Stable'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
    end
    if HD.Erosion(n)=='Accretion'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length_CFP(n);
            end
        end
    end
end


set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 12)
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=30;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable','Accretion');
legend('boxoff');
legend('Location','southoutside');

lgd.NumColumns = 3;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'b)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.063767429184258         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvanta_Erosion_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\EPS\Disadvanta_Erosion_Length'); %<-Save as PDF with 300 DPI
