%% COASTALRES ANALYSIS: FIGURES %%    

%% Date: 02/06/2020 %%

%% Figure 4 Flood and erosion -- Population density

%% Population density by risk of flooding (PU)

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.Flood(n)=='High'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Flood(n)=='Medium'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Flood(n)=='Low'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
axis([1 11 0 70])

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'});
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\4a'); %<-Save as PDF with 300 DPI
%% Population density by risk of flooding (area)

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Flood(n)=='High'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Flood(n)=='Medium'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Flood(n)=='Low'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
axis([1.5 10.5 0.01 5000])

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\4b'); %<-Save as PDF with 300 DPI

%% Population density by shoreline change (PU)

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.Erosion(n)== 'Erosion'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Erosion(n) == 'Stable'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Accretion'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end


escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10)
axis([1 11 0 50])

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on
lgd= legend('Erosion','Stable','Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'});
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\4c'); 
 


%% Population density by shoreline change (Length)

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Erosion(n)== 'Erosion'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Stable'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Accretion'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10)
axis([1.5 10.5 0.01 1000])

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length   [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10)
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\4d');  

%% Figure 5 Flood and erosion (Built area) %%
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;
%% Built area vs Flood

x= (2:8)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.Flood(n)=='High'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Flood(n)=='Medium'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Flood(n)=='Low'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3]);

axis([1 8 0 40]);

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'});
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\5a'); %<-Save as PDF with 300 DPI
%% Built area vs Erosion
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.Erosion(n)== 'Erosion'
        for m = 2:10
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Stable'
        for m = 2:10
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Accretion'
        for m = 2:10
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3]);

axis([1 8 0 40]);

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\5b'); %<-Save as PDF with 300 DPI

%% Figure 6 Defences Length %%

%% Defences - pop density

CFP.PopDen_Class (CFP.PopDen_Class==0)= nan;
CFP.PopDen_Class (CFP.PopDen_Class==1)= nan;

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Def_Type(n)=='Natural'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Engineered'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Combo'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
axis([1.5 10.5 0.01 2000]);

x0=0;
y0=0;
width=9;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Length   [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10)
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\6a'); %<-Save as PDF with 300 DPI %<-Save as PDF with 300 DPI

%% Built area vs Defences
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Def_Type(n)=='Natural'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Engineered'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Combo'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])

axis([1.5 7.5 0.01 1000]);

x0=0;
y0=0;
width=9;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Length   [km]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);


print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\6b'); %<-Save as PDF with 300 DPI
%% Figure 7 SMP - Pop density %%

%% Population density vs SMP short term (PU)
CFP.PopDen_Class (CFP.PopDen_Class==0)= nan;
CFP.PopDen_Class (CFP.PopDen_Class==1)= nan;

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.policy_20(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.policy_20(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1 11 0 80])

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
% lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\7a'); %<-Save as PDF with 300 DPI
%% Population density vs SMP short term (length)
x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_20(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_20(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
axis([1.5 10.5 0.01 2000])

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
% lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length  [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize',10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\7b'); %<-Save as PDF with 300 DPI

%% Figure 8 Policies (HTL, MR, NAI) - length

%% SMP - HTL - length

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;


for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_100(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
axis([1.5 10.5 0.01 1000])

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length  [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\8a'); %<-Save as PDF with 300 DPI

%% SMP - MR - length

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;


for n=1:1364
    if CFP.policy_20(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1000])

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length  [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\8b'); %<-Save as PDF with 300 DPI

%% SMP - NAI - length

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;


for n=1:1364
    if CFP.policy_20(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1000])

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length  [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\8c'); %<-Save as PDF with 300 DPI
%% Figure 10 Hazards for high and low disadvantage

LD= CFP(CFP.Disad_Clas=='Low',:);
HD= CFP(CFP.Disad_Clas=='High',:);
%% Flooding likelihood - area

% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.Flood(n)=='High'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Area_km2(n);
            end
        end
    end
     if LD.Flood(n)== 'Medium'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Area_km2(n);
            end
        end
    end
    if LD.Flood (n)== 'Low'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 10);
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total area   [km^2]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'a)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.Flood (n)=='High'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Area_km2(n);
            end
        end
    end
     if HD.Flood(n)== 'Medium'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Area_km2(n);
            end
        end
    end
    if HD.Flood(n)== 'Low'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Area_km2(n);
            end
        end
    end
end


set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=16;
height=9;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
set(lgd, 'FontSize', 10);

lgd.NumColumns = 3;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total area   [km^2]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'b)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.007         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\10a'); %<-Save as PDF with 300 DPI

%% Shoreline change - area
% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.Erosion(n)=='Erosion'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.Erosion(n)== 'Stable'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
    if LD.Erosion (n)== 'Accretion'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 10);
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'a)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.Erosion (n)=='Erosion'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.Erosion(n)== 'Stable'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
    end
    if HD.Erosion(n)== 'Accretion'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length_CFP(n);
            end
        end
    end
end


set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=16;
height=9;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
set(lgd, 'FontSize', 10);

lgd.NumColumns = 3;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length  [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'b)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.007         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\10b'); %<-Save as PDF with 300 DPI

%% Defences - length
% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.Def_Type(n)=='Natural'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.Def_Type(n)== 'Engineered'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
    if LD.Def_Type (n)== 'Combo'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 10);
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'a)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.Def_Type (n)=='Natural'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.Def_Type(n)== 'Engineered'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
    end
    if HD.Def_Type(n)== 'Combo'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length_CFP(n);
            end
        end
    end
end


set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=16;
height=9;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combo');
legend('boxoff');
legend('Location','southoutside');
set(lgd, 'FontSize', 10);

lgd.NumColumns = 3;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length  [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'b)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.007         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\11'); %<-Save as PDF with 300 DPI
% 
%% Percentage of engineered defences - Disadvantage - length

CFP2= CFP(CFP.Eng_Perc_Class~=-1,:);

classes=(0:10:110)';
Nc=length(classes)-1;

Nr=length(CFP2.Eng_Perc); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if CFP2.Eng_Perc(r)>=classes(c) && CFP2.Eng_Perc(r)<classes(c+1)
            CL(r) = c;
        end
    end
end

x= classes;

y1= x*0;
y2= x*0;

for n=1:Nr
    if CFP2.Disad_Clas (n)=='Low'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + CFP2.Length_CFP(n);
            end
        end
    end
     if CFP2.Disad_Clas(n)== 'High'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + CFP2.Length_CFP(n);
            end
        end
    end
end

escalera_2(x,[y1,y2])


axis([-10 110 0 550])

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Low disadvantage', 'High disadvantage');
legend('boxoff');
legend('Location','southoutside');
% lgd.NumColumns = 2
xlabel('% of engineered defences','fontweight', 'bold');
ylabel ('Total length   [km]','fontweight', 'bold');
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize',10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\12d'); %<-Save as PDF with 300 DPI


%% ENG PERC vs POP DEN

CFP2= CFP(CFP.Eng_Perc_Class~=-1,:);

LD2= CFP2(CFP2.Disad_Clas=='Low',:);
HD2= CFP2(CFP2.Disad_Clas=='High',:);
g1= findgroups(HD2.PopDen_Class);
g2= findgroups(LD2.PopDen_Class);

x1=HD2.PopDen_Class;
y1=HD2.Eng_Perc;
x2=LD2.PopDen_Class;
y2=LD2.Eng_Perc;

x3= unique(HD2.PopDen_Class);
y3= splitapply(@mean, HD2.Eng_Perc,g1);
sz3= splitapply(@sum, HD2.Length_CFP,g1);
x4= unique(LD2.PopDen_Class);
y4= splitapply(@mean, LD2.Eng_Perc,g2);
sz4= splitapply(@sum, LD2.Length_CFP,g2);

hold on
s1=scatter(x1,y1);
s2=scatter(x2,y2);
s3=scatter(x3,y3,sz3);
s4=scatter(x4,y4,sz4);
set(s1,'MarkerEdgeColor',[255,127,127]/255, 'MarkerFaceColor',[255,127,127]/255, 'MarkerEdgeAlpha', 0.05, 'MarkerFaceAlpha', 0.05);
set(s2,'MarkerEdgeColor',[127,127,127]/255, 'MarkerFaceColor',[127,127,127]/255, 'MarkerEdgeAlpha', 0.05, 'MarkerFaceAlpha', 0.05);
set(s3,'MarkerEdgeColor',[1,0,0], 'MarkerFaceColor',[1,0,0]);
set(s4,'MarkerEdgeColor',[0,0,0], 'MarkerFaceColor',[0,0,0]);

set(gca, 'xtick', (0:11));
xticklabels({'0','1-25','25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend([s3 s4],'High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
% lgd.NumColumns = 2;
h6= ylabel('% of engineered defences','fontweight', 'bold');
h7= xlabel ('Population density   [people/km^2]','fontweight', 'bold');
axis([-0.5 10.5 0 100]);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\12c'); %<-Save as PDF with 300 DPI
%% ENG PERC vs BUILT-UP INTENSITY

g1= findgroups(HD2.Build_Perc_Class);
g2= findgroups(LD2.Build_Perc_Class);

x1=HD2.Build_Perc_Class;
y1=HD2.Eng_Perc;
x2=LD2.Build_Perc_Class;
y2=LD2.Eng_Perc;

x3= unique(HD2.Build_Perc_Class);
y3= splitapply(@median, HD2.Eng_Perc,g1);
sz3= splitapply(@sum, HD2.Length_CFP,g1);
x4= unique(LD2.Build_Perc_Class);
y4= splitapply(@median, LD2.Eng_Perc,g2);
sz4= splitapply(@sum, LD2.Length_CFP,g2);

hold on
s1=scatter(x1,y1);
s2=scatter(x2,y2);
s3=scatter(x3,y3,sz3);
s4=scatter(x4,y4,sz4);
set(s1,'MarkerEdgeColor',[255,127,127]/255, 'MarkerFaceColor',[255,127,127]/255, 'MarkerEdgeAlpha', 0.05, 'MarkerFaceAlpha', 0.05);
set(s2,'MarkerEdgeColor',[127,127,127]/255, 'MarkerFaceColor',[127,127,127]/255, 'MarkerEdgeAlpha', 0.05, 'MarkerFaceAlpha', 0.05);
set(s3,'MarkerEdgeColor',[1,0,0], 'MarkerFaceColor',[1,0,0]);
set(s4,'MarkerEdgeColor',[0,0,0], 'MarkerFaceColor',[0,0,0]);

set(gca, 'xtick', (0:7));
xticklabels({'0','0-5','5-10', '10-15','15-20','20-25','25-30','>30'})
set(gca, 'XTickLabelRotation', 45);

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend([s3 s4],'High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
% lgd.NumColumns = 2;
h6= ylabel('% of engineered defences','fontweight', 'bold');
h7= xlabel ('Built area   [%]','fontweight', 'bold');
axis([-0.5 7.5 0 100]);
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\12b'); %<-Save as PDF with 300 DPI

%% Scatter plot SHORELINE CHANGE vs Buildup class
set(0,'DefaultLegendAutoUpdate','off');
LD= CFP(CFP.Disadvanta<-0.5,:);
HD= CFP(CFP.Disadvanta>0.5,:);

g1= findgroups(HD.Build_Perc_Class);
g2= findgroups(LD.Build_Perc_Class);

x1=HD.Build_Perc_Class;
y1=HD.ChangeRate;
x2=LD.Build_Perc_Class;
y2=LD.ChangeRate;

hold on
s1=scatter(x1,y1);
s2=scatter(x2,y2);
set(s1,'MarkerEdgeColor',[1,0,0], 'MarkerFaceColor',[1,0,0]);
set(s2,'MarkerEdgeColor',[0,0,0], 'MarkerFaceColor',[0,0,0]);

set(gca, 'xtick', (0:7));
xticklabels({'0','0-5','5-10', '10-15','15-20','20-25','25-30','>30'})
set(gca, 'XTickLabelRotation', 45);

x0=0;
y0=0;
width=8;
height=10;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend([s1 s2],'High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
% lgd.NumColumns = 2;
h6= ylabel('Shoreline change rate   [m/yr]','fontweight', 'bold');
h7= xlabel ('Built area  [%]','fontweight', 'bold');
axis([-0.5 7.5 -4 4]);
ll = yline(0.5,'--','Accretion','LineWidth',1, 'fontweight', 'bold');
l2 = yline(-0.5,'--','Erosion','LineWidth',1, 'fontweight', 'bold');
l2.LabelVerticalAlignment = 'bottom';
set(gca, 'FontName', 'Arial', 'FontSize', 10);
set(lgd, 'FontSize', 10);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\12a'); %<-Save as PDF with 300 DPI

%% Figure 13 SMP in ST and LT by disadvantage

%% SMP policies ST - Length
LD= CFP(CFP.Disad_Clas=='Low',:);
HD= CFP(CFP.Disad_Clas=='High',:);

% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.policy_20(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.policy_20(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
    if LD.policy_20 (n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 10)
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'a)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.policy_20 (n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.policy_20(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
    end
    if HD.policy_20(n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length_CFP(n);
            end
        end
    end
end


set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10)
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=16;
height=9;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
set(lgd, 'FontSize', 10);

lgd.NumColumns = 3;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'b)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.007         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\13a'); %<-Save as PDF with 300 DPI

%% SMP policies ST - Length

% LD 
hhh= figure;
subplot(1,2,1);

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if LD.policy_100(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length_CFP(n);
            end
        end
    end
     if LD.policy_100(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length_CFP(n);
            end
        end
    end
    if LD.policy_100 (n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
set(gca, 'XTickLabelRotation', 45);
% xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Arial', 'FontSize', 10)
axis([-1.75 -0.55 0.01 2000])

box on
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

set(gca, 'position', [ 0.13         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'a)','Units','normalized', 'fontsize',15)

% HD 

subplot(1,2,2);

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:Nr
    if HD.policy_100 (n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length_CFP(n);
            end
        end
    end
     if HD.policy_100(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length_CFP(n);
            end
        end
    end
    if HD.policy_100(n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length_CFP(n);
            end
        end
    end
end


set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 10)
axis([0.25 5.25 0.01 2000])

x0=0;
y0=0;
width=16;
height=9;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
set(lgd, 'FontSize', 10);

lgd.NumColumns = 3;

xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');
set(gca, 'position', [0.570340909090909         0.246235294117647         0.334659090909091         0.678764705882353]);
% text(-0.15,1.07,'b)','Units','normalized', 'fontsize',15)


set(lgd, 'position', [0.290691064079952         0.007         0.464138741916519        0.0364705882352941]);

print(gcf, '-dpng', '-r300', 'A:\A1_ENGLAND_COASTALRISKS\CoastalRes_CFP_070520\Plots_Figures\13b'); %<-Save as PDF with 300 DPI
