%% COASTALRES ANALYSIS: COASTAL FLOODPLAIN - PU - EUCLIDEAN ALLOCATION FLOODPLAIN %%    

%% Date: 29/04/2020 %%

LD= CFP(CFP.Disadvanta<-0.5,:);
HD= CFP(CFP.Disadvanta>0.5,:);

%% HD- ST

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.policy_20(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Ones(n);
            end
        end
    end
     if HD.policy_20(n)=='MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Ones(n);
            end
        end
    end
    if HD.policy_20(n)=='NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Ones(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([0 4.55 0 120])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_ST'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_ST'); %<-Save as PDF with 300 DPI

%% HD- LT

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.policy_100(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Ones(n);
            end
        end
    end
     if HD.policy_100(n)=='MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Ones(n);
            end
        end
    end
    if HD.policy_100(n)=='NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Ones(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([0 4.55 0 100])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_LT'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_LT'); %<-Save as PDF with 300 DPI

%% HD - HTL

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.policy_20(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Ones(n);
            end
        end
    end
     if HD.policy_100(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Ones(n);
            end
        end
    end
end

escalera_2(x,[y1,y2])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([0 4.55 0 120])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_HTL'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_HTL'); %<-Save as PDF with 300 DPI

%% HD - MR

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.policy_20(n)=='MR'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Ones(n);
            end
        end
    end
     if HD.policy_100(n)=='MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Ones(n);
            end
        end
    end
end

escalera_2(x,[y1,y2])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([0 4.55 0 40])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_MR'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_MR'); %<-Save as PDF with 300 DPI

%% HD - NAI

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.policy_20(n)=='NAI'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Ones(n);
            end
        end
    end
     if HD.policy_100(n)=='NAI'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Ones(n);
            end
        end
    end
end

escalera_2(x,[y1,y2])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([0 4.55 0 25])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_NAI'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_NAI'); %<-Save as PDF with 300 DPI

%% HD- Defences

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.Def_Type(n)=='Natural'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Ones(n);
            end
        end
    end
     if HD.Def_Type(n)=='Engineered'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Ones(n);
            end
        end
    end
    if HD.Def_Type(n)=='Combo'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Ones(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([0 4.55 0 150])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Defences'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Defences'); %<-Save as PDF with 300 DPI

%% HD- Flood

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.Flood(n)=='High'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Ones(n);
            end
        end
    end
     if HD.Flood(n)=='Medium'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Ones(n);
            end
        end
    end
    if HD.Flood(n)=='Low'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Ones(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([0 4.55 0 110])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Flood'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Flood'); %<-Save as PDF with 300 DPI

%% HD- Erosion

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.Erosion(n)< -0.5 
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Ones(n);
            end
        end
    end
     if HD.Erosion(n)>= -0.5 && HD.Erosion (n) <=0.5
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Ones(n);
            end
        end
    end
    if HD.Erosion(n)> 0.5
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Ones(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([0 4.55 0 80])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Erosion'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Erosion'); %<-Save as PDF with 300 DPI
