%% COASTALRES ANALYSIS: COASTAL FLOODPLAIN - PU - EUCLIDEAN ALLOCATION FLOODPLAIN %%    

%% Date: 15/04/2020 %%

%% POPULATION DENSITY vs PU AREA%%

%% Flooding likelihood

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Flood(n)=='High'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Flood(n)=='Medium'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Flood(n)=='Low'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_Flood_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_Flood_Area'); %<-Save as PDF with 300 DPI

%% Shoreline change - area

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Erosion(n)== 'Erosion'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Stable'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Accretion'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total area  [km^2]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_Erosion_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_Erosion_Area'); %<-Save as PDF with 300 DPI

%% Shoreline change - length

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Erosion(n)== 'Erosion'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Stable'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Accretion'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 200])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length   [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_Erosion_Length_CFP'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_Erosion_Length_CFP'); %<-Save as PDF with 300 DPI

%% Defences

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Def_Type(n)=='Natural'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Engineered'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Combo'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 400])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length   [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_Defences_Length_CFP'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_Defences_Length_CFP'); %<-Save as PDF with 300 DPI

%% Defences

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Def_Type(n)=='Natural'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Engineered'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Combo'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total area  [km^2]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_Defences_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_Defences_Area'); %<-Save as PDF with 300 DPI

%% SMP - Short Term - length

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_20(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_20(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 350])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length  [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_ST_Length_CFP'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_ST_Length_CFP'); %<-Save as PDF with 300 DPI

%% SMP - Short Term - area

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_20(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_20(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1550])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total area  [km^2]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_ST_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_ST_Area'); %<-Save as PDF with 300 DPI

%% SMP - Long Term - length

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_100(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_km(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_km(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_km(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 350])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length  [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_LT_Length_PU'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_LT_Length_PU'); %<-Save as PDF with 300 DPI

%% SMP - Long Term - area

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_100(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1550])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total area  [km^2]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_LT_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_LT_Area'); %<-Save as PDF with 300 DPI

%% SMP - HTL - length

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;


for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_100(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 350])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length  [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_HTL_Length_CFP'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_HTL_Length_CFP'); %<-Save as PDF with 300 DPI

%% SMP - HTL - area

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;


for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_100(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])



set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1550])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total area  [km^2]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_HTL_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_HTL_Area'); %<-Save as PDF with 300 DPI

%% SMP - MR - length

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;


for n=1:1364
    if CFP.policy_20(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_km(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_km(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 350])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length  [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_MR_Length_PU'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_MR_Length_PU'); %<-Save as PDF with 300 DPI

%% SMP - MR - area

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;


for n=1:1364
    if CFP.policy_20(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])



set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total area  [km^2]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_MR_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_MR_Area'); %<-Save as PDF with 300 DPI

%% SMP - NAI - length

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;


for n=1:1364
    if CFP.policy_20(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_km(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_km(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 350])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total length  [km]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_NAI_Length_PU'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_NAI_Length_PU'); %<-Save as PDF with 300 DPI

%% SMP - NAI - area

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;


for n=1:1364
    if CFP.policy_20(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])



set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1550])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total area  [km^2]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_NAI_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_NAI_Area'); %<-Save as PDF with 300 DPI

%% SMP - Disadvantage - area

x= (2:10)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Disad_Clas(n)=='High'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Disad_Clas(n)=='Medium'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Disad_Clas(n)=='Low'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1.5 10.5 0.01 1550])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Total area  [km^2]', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_Disadvanta_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_Disadvanta_Area'); %<-Save as PDF with 300 DPI
