%% COASTALRES ANALYSIS: COASTAL FLOODPLAIN - PU - EUCLIDEAN ALLOCATION FLOODPLAIN %%    

%% Date: 01/05/2020 %%

%% changerate TRANSECTS %%

%% Scatter plot SHORELINE CHANGE vs % ENG DEFENCES by DI


LD= a(a.Disadvanta<-0.5,:);
HD= a(a.Disadvanta>0.5,:);

g1= findgroups(HD.Eng_Perc_Class);
g2= findgroups(LD.Eng_Perc_Class);

x1= HD.Eng_Perc_Class;
y1= HD.changerate;
x2= LD.Eng_Perc_Class;
y2= LD.changerate;

x3= unique(HD.Eng_Perc_Class);
y3= splitapply(@median, HD.changerate,g1);
sz3=200;
x4= unique(LD.Eng_Perc_Class);
y4= splitapply(@median, LD.changerate,g2);
sz4= 200;

hold on
s1=scatter(x1,y1);
s2=scatter(x2,y2);
s3=scatter(x3,y3,sz3);
s4=scatter(x4,y4,sz4);
set(s1,'MarkerEdgeColor',[255,127,127]/255, 'MarkerFaceColor',[255,127,127]/255, 'MarkerEdgeAlpha', 0.2, 'MarkerFaceAlpha', 0.2);
set(s2,'MarkerEdgeColor',[127,127,127]/255, 'MarkerFaceColor',[127,127,127]/255, 'MarkerEdgeAlpha', 0.2, 'MarkerFaceAlpha', 0.2);
set(s3,'MarkerEdgeColor',[1,0,0], 'MarkerFaceColor',[1,0,0]);
set(s4,'MarkerEdgeColor',[0,0,0], 'MarkerFaceColor',[0,0,0]);

set(gca, 'xtick', (0:10));
xticklabels({'0','10','20', '30','40','50','60','70','80', '90', '100'})

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend([s3,s4],'High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2;
set(gca, 'FontName', 'Arial', 'FontSize', 11)
h6= ylabel('Shoreline change rate   [m/yr]','fontweight', 'bold');
h7= xlabel ('Percentage of engineered defences','fontweight', 'bold');
axis([-0.5 10.5 -4 4])
% yticks([ -2.5 -2 -1.5 -1 -0.5 0 0.5 1 1.5 2 2.5 3])
ll = yline(0.5,'--','Accretion','LineWidth',1, 'fontweight', 'bold');
l2 = yline(-0.5,'--','Erosion','LineWidth',1, 'fontweight', 'bold');
l2.LabelVerticalAlignment = 'bottom';


print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\Changerate_EngDefences'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\EPS\Changerate_EngDefences'); %<-Save as PDF with 300 DPI

