%% COASTALRES ANALYSIS: COASTAL FLOODPLAIN - PU - EUCLIDEAN ALLOCATION FLOODPLAIN %%    

%% Date: 29/04/2020 %%

%% BUILT PERCENTAGE%%

%% Built area vs SMP short term
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_20(n)=='MR'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_20(n)=='NAI'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])

axis([1.5 7.5 0 220])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total length   [km]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_ST_Length_CFP'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_ST_Length_CFP'); %<-Save as PDF with 300 DPI

%% Built area vs SMP short term - area
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;


for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_20(n)=='MR'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_20(n)=='NAI'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])

axis([1.5 7.5 0 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_ST_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_ST_Area'); %<-Save as PDF with 300 DPI

%% Built length vs SMP long term
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_100(n)=='HTL'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])

axis([1.5 7.5 0 220])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total length   [km]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_LT_Length_CFP'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_LT_Length_CFP'); %<-Save as PDF with 300 DPI

%% Built area vs SMP long term - area
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;


for n=1:1364
    if CFP.policy_100(n)=='HTL'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])

axis([1.5 7.5 0 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_LT_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_LT_Area'); %<-Save as PDF with 300 DPI

%% Built length vs HTL
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_100(n)=='HTL'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])

axis([1.5 7.5 0 220])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total length   [km]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_HTL_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_HTL_Length'); %<-Save as PDF with 300 DPI

%% Built area vs HTL
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_100(n)=='HTL'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])

axis([1.5 7.5 0 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_HTL_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_HTL_Area'); %<-Save as PDF with 300 DPI

%% Built length vs MR
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_20(n)=='MR'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])

axis([1.5 7.5 0 220])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total length   [km]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_MR_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_MR_Length'); %<-Save as PDF with 300 DPI

%% Built area vs MR
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_20(n)=='MR'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])

axis([1.5 7.5 0 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_MR_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_MR_Area'); %<-Save as PDF with 300 DPI


%% Built length vs NAI
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_20(n)=='NAI'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])

axis([1.5 7.5 0 220])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total length   [km]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_NAI_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_NAI_Length'); %<-Save as PDF with 300 DPI

%% Built area vs NAI
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.policy_20(n)=='NAI'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    
end

set(gca, 'yscale', 'log');
escalera_2(x,[y1,y2])

axis([1.5 7.5 0 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_NAI_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_NAI_Area'); %<-Save as PDF with 300 DPI

%% Built length vs Defences

CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Def_Type(n)=='Natural'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Engineered'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Combo'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])

axis([1.5 7.5 0 250])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total length   [km]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_Defences_Length_CFP'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_Defences_Length_CFP'); %<-Save as PDF with 300 DPI

%% Built area vs Defences

CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Def_Type(n)=='Natural'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Engineered'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Combo'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera_gris(x,[y1,y2,y3])

axis([1.5 7.5 0 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_Defences_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_Defences_Area'); %<-Save as PDF with 300 DPI

%% Built area vs Flood
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Flood(n)=='High'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Flood(n)=='Medium'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Flood(n)=='Low'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])

axis([1.5 7.5 0 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_Flood_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_Flood_Area'); %<-Save as PDF with 300 DPI

%% Built length vs Erosion
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Erosion(n)== 'Erosion'
        for m = 2:10
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Stable'
        for m = 2:10
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Length_CFP(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Accretion'
        for m = 2:10
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Length_CFP(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])

axis([1.5 7.5 0 180])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total length   [km]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_Erosion_Length_CFP'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_Erosion_Length_CFP'); %<-Save as PDF with 300 DPI

%% Built area vs Erosion
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Erosion(n)== 'Erosion'
        for m = 2:10
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Stable'
        for m = 2:10
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Accretion'
        for m = 2:10
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])

axis([1.5 7.5 0 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_Erosion_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_Erosion_Area'); %<-Save as PDF with 300 DPI

%% Built area vs disadvantage
CFP.Build_Perc_Class (CFP.Build_Perc_Class==0)= nan;
CFP.Build_Perc_Class (CFP.Build_Perc_Class==1)= nan;

x= (2:8)';

y1= x*0+0.01;
y2= x*0+0.01;
y3= x*0+0.01;

for n=1:1364
    if CFP.Disad_Clas(n)=='High'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Disad_Clas(n)=='Medium'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Area_km2(n);
            end
        end
    end
    if CFP.Disad_Clas(n)=='Low'
        for m = 2:8
            if CFP.Build_Perc_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Area_km2(n);
            end
        end
    end
end

set(gca, 'yscale', 'log');
escalera(x,[y1,y2,y3])

axis([1.5 7.5 0 1000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Built area', 'fontweight', 'bold');
ylabel('Total area   [km^2]', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:8));
xticklabels({'5-10%','10-15%','15-20%','20-25%','25-30%','> 30%'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\BuildPerc_Disadvantage_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Buildings\EPS\BuildPerc_Disadvantage_Area'); %<-Save as PDF with 300 DPI

