%% COASTALRES ANALYSIS: COASTAL FLOODPLAIN - PU - EUCLIDEAN ALLOCATION FLOODPLAIN %%    

%% Date: 30/04/2020 %%

%% HIGH DISADVANTAGE vs PU AREA/PU LENGTH%%

LD= CFP(CFP.Disadvanta<-0.5,:);
HD= CFP(CFP.Disadvanta>0.5,:);
LD.Erosion(LD.Erosion==0)= nan;
HD.Erosion(HD.Erosion==0)= nan;

%% HD - SMP policies ST - length

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.policy_20 (n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length(n);
            end
        end
    end
     if HD.policy_20(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length(n);
            end
        end
    end
    if HD.policy_20(n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([0 4.5 0 600])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_ST_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_ST_Length'); %<-Save as PDF with 300 DPI

%% HD - SMP policies ST - area

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.policy_20 (n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Area_km2(n);
            end
        end
    end
     if HD.policy_20(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Area_km2(n);
            end
        end
    end
    if HD.policy_20(n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Area_km2(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([0 4.5 0 1800])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total area   [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_ST_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_ST_Area'); %<-Save as PDF with 300 DPI

%% HD - SMP policies LT - length

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.policy_100 (n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length(n);
            end
        end
    end
     if HD.policy_100(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length(n);
            end
        end
    end
    if HD.policy_100(n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([0 4.5 0 450])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_LT_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_LT_Length'); %<-Save as PDF with 300 DPI

%% HD - SMP policies LT

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.policy_100 (n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Area_km2(n);
            end
        end
    end
     if HD.policy_100(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Area_km2(n);
            end
        end
    end
    if HD.policy_100(n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Area_km2(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([0 4.5 0 1800])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total area  [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_LT_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_LT_Area'); %<-Save as PDF with 300 DPI

%% HD - Defences - length

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.Def_Type(n)=='Natural'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length(n);
            end
        end
    end
     if HD.Def_Type(n)== 'Engineered'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length(n);
            end
        end
    end
    if HD.Def_Type(n)== 'Combo'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([0 4.5 0 700])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Defences_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Defences_Length'); %<-Save as PDF with 300 DPI

%% HD - Defences - area

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.Def_Type(n)=='Natural'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Area_km2(n);
            end
        end
    end
     if HD.Def_Type(n)== 'Engineered'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Area_km2(n);
            end
        end
    end
    if HD.Def_Type(n)== 'Combo'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Area_km2(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([0 4.5 0 2000])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total area   [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Defences_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Defences_Area'); %<-Save as PDF with 300 DPI

%% HD - Flooding - area

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.Flood(n)=='High'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Area_km2(n);
            end
        end
    end
     if HD.Flood(n)=='Medium'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Area_km2(n);
            end
        end
    end
    if HD.Flood(n)=='Low'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Area_km2(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([0 4.55 0 1800])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total area   [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Flood_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Flood_Area'); %<-Save as PDF with 300 DPI

%% HD - Shoreline change - length

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.Erosion(n)<-0.5
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Length(n);
            end
        end
    end
     if HD.Erosion(n)>= -0.5 && HD.Erosion (n) <=0.5
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Length(n);
            end
        end
    end
    if HD.Erosion(n)> 0.5
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Length(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([0 4.5 0 400])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Erosion_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Erosion_Length'); %<-Save as PDF with 300 DPI

%% HD - Shoreline change

classes=(0.5:0.5:5)';
Nc=length(classes)-1;

Nr=length(HD.Disadvanta); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if HD.Disadvanta(r)>=classes(c) && HD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if HD.Erosion(n)<-0.5
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + HD.Area_km2(n);
            end
        end
    end
     if HD.Erosion(n)>= -0.5 && HD.Erosion (n) <=0.5
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + HD.Area_km2(n);
            end
        end
    end
    if HD.Erosion(n)> 0.5
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + HD.Area_km2(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([0 4.5 0 1500])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('High disadvantage index', 'fontweight', 'bold');
ylabel('Total area  [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Erosion_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\HD_Erosion_Area'); %<-Save as PDF with 300 DPI

%% % of engineered defences - Disadvantage


classes=(0:10:110)';
Nc=length(classes)-1;

Nr=length(CFP.Eng_Perc); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if CFP.Eng_Perc(r)>=classes(c) && CFP.Eng_Perc(r)<classes(c+1)
            CL(r) = c;
        end
    end
end

x= classes;

y1= x*0;
y2= x*0;

for n=1:Nr
    if CFP.Disad_Clas (n)=='Low'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + CFP.Ones(n);
            end
        end
    end
     if CFP.Disad_Clas(n)== 'High'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + CFP.Ones(n);
            end
        end
    end
end

escalera_2(x,[y1,y2])


% set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})

axis([-10 110 0 160])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Low disadvantage', 'High disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2
xlabel('% of engineered defences','fontweight', 'bold');
ylabel ('Policy Units','fontweight', 'bold');

% print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvantage_EngPerc'); %<-Save as PDF with 300 DPI
% print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvantage_EngPerc'); %<-Save as PDF with 300 DPI



%% % of engineered defences - Disadvantage - length



classes=(0:10:110)';
Nc=length(classes)-1;

Nr=length(CFP.Eng_Perc); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if CFP.Eng_Perc(r)>=classes(c) && CFP.Eng_Perc(r)<classes(c+1)
            CL(r) = c;
        end
    end
end

x= classes;

y1= x*0;
y2= x*0;

for n=1:Nr
    if CFP.Disad_Clas (n)=='Low'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + CFP.Length(n);
            end
        end
    end
     if CFP.Disad_Clas(n)== 'High'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + CFP.Length(n);
            end
        end
    end
end

escalera_2(x,[y1,y2])


% set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})

axis([-10 110 0 800])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Low disadvantage', 'High disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2
xlabel('% of engineered defences','fontweight', 'bold');
ylabel ('Total length   [km]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvantage_EngPerc_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvantage_EngPerc_Length'); %<-Save as PDF with 300 DPI

%% % of engineered defences - Disadvantage - area

Combo= CFP(CFP.Def_Type=='Combo',:);

classes=(0:10:110)';
Nc=length(classes)-1;

Nr=length(CFP.Eng_Perc); % Tamao de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if CFP.Eng_Perc(r)>=classes(c) && CFP.Eng_Perc(r)<classes(c+1)
            CL(r) = c;
        end
    end
end

x= classes;

y1= x*0;
y2= x*0;

for n=1:Nr
    if CFP.Disad_Clas (n)=='Low'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + CFP.Area_km2(n);
            end
        end
    end
     if CFP.Disad_Clas(n)== 'High'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + CFP.Area_km2(n);
            end
        end
    end
end

escalera_2(x,[y1,y2])


% set(gca, 'xtick', classes);
% xticklabels({' ' ,'1',' ','2',' ','3',' ','4',' ','5'})

axis([-10 110 0 1600])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Low disadvantage', 'High disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2
xlabel('% of engineered defences','fontweight', 'bold');
ylabel ('Total area   [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvantage_EngPerc_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Disadvantage_EngPerc_Area'); %<-Save as PDF with 300 DPI


