%% COASTALRES ANALYSIS: COASTAL FLOODPLAIN - PU - EUCLIDEAN ALLOCATION FLOODPLAIN %%    

%% Date: 30/04/2020 %%

%% LOW DISADVANTAGE vs PU AREA/PU LENGTH%%

LD= CFP(CFP.Disadvanta<-0.5,:);
HD= CFP(CFP.Disadvanta>0.5,:);
LD.Erosion(LD.Erosion==0)= nan;
HD.Erosion(HD.Erosion==0)= nan;

%% LD - SMP policies ST - length
classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if LD.policy_20(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length(n);
            end
        end
    end
     if LD.policy_20(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length(n);
            end
        end
    end
    if LD.policy_20 (n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([-1.8 -0.5 0 250])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_ST_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_ST_Length'); %<-Save as PDF with 300 DPI

%% LD - SMP policies ST - area
classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if LD.policy_20(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Area_km2(n);
            end
        end
    end
     if LD.policy_20(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Area_km2(n);
            end
        end
    end
    if LD.policy_20 (n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Area_km2(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([-1.8 -0.5 0 40])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total area   [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_ST_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_ST_Area'); %<-Save as PDF with 300 DPI


%% LD - SMP policies LT - length
classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if LD.policy_100(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length(n);
            end
        end
    end
     if LD.policy_100(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length(n);
            end
        end
    end
    if LD.policy_100 (n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([-1.8 -0.5 0 250])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_LT_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_LT_Length'); %<-Save as PDF with 300 DPI

%% LD - SMP policies LT - area
classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if LD.policy_100(n)=='HTL'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Area_km2(n);
            end
        end
    end
     if LD.policy_100(n)== 'MR'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Area_km2(n);
            end
        end
    end
    if LD.policy_100 (n)== 'NAI'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Area_km2(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([-1.8 -0.5 0 40])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total area   [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_LT_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_LT_Area'); %<-Save as PDF with 300 DPI

%% LD - Defences - length
classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if LD.Def_Type(n)=='Natural'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length(n);
            end
        end
    end
     if LD.Def_Type(n)== 'Engineered'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length(n);
            end
        end
    end
    if LD.Def_Type(n)== 'Combo'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([-1.8 -0.5 0 220])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_Defences_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_Defences_Length'); %<-Save as PDF with 300 DPI

%% LD - Defences - area
classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if LD.Def_Type(n)=='Natural'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Area_km2(n);
            end
        end
    end
     if LD.Def_Type(n)== 'Engineered'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Area_km2(n);
            end
        end
    end
    if LD.Def_Type(n)== 'Combo'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Area_km2(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([-1.8 -0.5 0 45])


x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total area   [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_Defences_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\Low\LD_Defences_Area'); %<-Save as PDF with 300 DPI

%% LD - Flooding

classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if LD.Flood(n)=='High'
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Area_km2(n);
            end
        end
    end
     if LD.Flood(n)=='Medium'
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Area_km2(n);
            end
        end
    end
    if LD.Flood(n)=='Low'
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Area_km2(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([-1.8 -0.5 0 50])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total area   [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\LD_Flood_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\LD_Flood_Area'); %<-Save as PDF with 300 DPI

%% LD - Shoreline change
classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if LD.Erosion(n)<-0.5
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Length(n);
            end
        end
    end
     if LD.Erosion(n)>= -0.5 && LD.Erosion (n) <=0.5
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Length(n);
            end
        end
    end
    if LD.Erosion(n)> 0.5
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Length(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([-1.8 -0.5 0 140])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total length   [km]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\LD_Erosion_Length'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\LD_Erosion_Length'); %<-Save as PDF with 300 DPI

%% LD - Shoreline change
classes=(-2:0.1:-0.5)';
Nc=length(classes)-1;

Nr=length(LD.Disadvanta); % Tamaño de la excel

CL=zeros(Nr,1);

for r=1:Nr
    for c=1:Nc
        if LD.Disadvanta(r)>=classes(c) && LD.Disadvanta(r)<classes(c+1)
            CL(r) = c;
        end
    end
end


x= classes;

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:Nr
    if LD.Erosion(n)<-0.5
        for m = 1:Nc
            if CL (n) ==m
               y1(m) = y1(m) + LD.Area_km2(n);
            end
        end
    end
     if LD.Erosion(n)>= -0.5 && LD.Erosion (n) <=0.5
        for m = 1:Nc
            if CL (n) ==m
               y2(m) = y2(m) + LD.Area_km2(n);
            end
        end
    end
    if LD.Erosion(n)> 0.5
        for m = 1:Nc
            if CL (n) ==m
               y3(m) = y3(m) + LD.Area_km2(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', classes);
xticklabels({' ' ,' ','-1.8',' ','-1.6',' ','-1.4',' ','-1.2',' ','-1',' ','-0.8',' ','-0.6',' '})
set(gca, 'FontName', 'Times New Roman', 'FontSize', 12)
axis([-1.8 -0.5 0 35])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable', 'Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Low disadvantage index', 'fontweight', 'bold');
ylabel('Total area   [km^2]','fontweight', 'bold');

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\LD_Erosion_Area'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Disadvantage\High\LD_Erosion_Area'); %<-Save as PDF with 300 DPI
