%% COASTALRES ANALYSIS: COASTAL FLOODPLAIN - PU - EUCLIDEAN ALLOCATION FLOODPLAIN %%    

%% Date: 13/04/2020 %%

%% POPULATION DENSITY%%

%% Population density vs SMP short term
CFP.PopDen_Class (CFP.PopDen_Class==0)= nan;
CFP.PopDen_Class (CFP.PopDen_Class==1)= nan;

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.policy_20(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.policy_20(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1 11 0 75])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');
%title({'Total Population density by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_ST'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_ST'); %<-Save as PDF with 300 DPI

%% Pop density vs SMP long term

CFP.PopDen_Class (CFP.PopDen_Class==0)= nan;
CFP.PopDen_Class (CFP.PopDen_Class==1)= nan;

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.policy_100(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1 11 0 70])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_LT'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_LT'); %<-Save as PDF with 300 DPI

%% Pop density vs HTL

CFP.PopDen_Class (CFP.PopDen_Class==0)= nan;
CFP.PopDen_Class (CFP.PopDen_Class==1)= nan;

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.policy_20(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.policy_100(n)=='HTL'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    
end

escalera_2(x,[y1,y2])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1 11 0 75])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_HTL'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_HTL'); %<-Save as PDF with 300 DPI

%% Population density by SMP policies: MR

CFP.PopDen_Class (CFP.PopDen_Class==0)= nan;
CFP.PopDen_Class (CFP.PopDen_Class==1)= nan;

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.policy_20(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.policy_100(n)=='MR'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    
end

escalera_2(x,[y1,y2])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1 11 0 20])
x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_MR'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_MR'); %<-Save as PDF with 300 DPI

%% Population density by SMP policies: NAI

CFP.PopDen_Class (CFP.PopDen_Class==0)= nan;
CFP.PopDen_Class (CFP.PopDen_Class==1)= nan;

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.policy_20(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.policy_100(n)=='NAI'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    
end

escalera_2(x,[y1,y2])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1 11 0 20])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Short-Term','Long-Term');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_NAI'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_NAI'); %<-Save as PDF with 300 DPI

%% Population density by defences

CFP.PopDen_Class (CFP.PopDen_Class==0)= nan;
CFP.PopDen_Class (CFP.PopDen_Class==1)= nan;

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.Def_Type(n)=='Natural'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Engineered'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Def_Type(n)=='Combo'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end

escalera_gris(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1 11 0 90])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Natural','Engineered', 'Combined');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_Defences'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_Defences'); %<-Save as PDF with 300 DPI

%% Population density by risk of flooding

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.Flood(n)=='High'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Flood(n)=='Medium'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Flood(n)=='Low'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1 11 0 65])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_Flood'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_Flood'); %<-Save as PDF with 300 DPI

%% Population density by shoreline change

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.Erosion(n)== 'Erosion'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Erosion(n) == 'Stable'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Erosion(n)== 'Accretion'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end


escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1 11 0 50])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('Erosion','Stable','Accretion');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_Erosion'); 
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_Erosion'); 

%% Population density by disadvantage

x= (2:10)';

y1= x*0;
y2= x*0;
y3= x*0;

for n=1:1364
    if CFP.Disad_Clas(n)=='High'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y1(m-1) = y1(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Disad_Clas(n)=='Medium'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y2(m-1) = y2(m-1) + CFP.Ones(n);
            end
        end
    end
    if CFP.Disad_Clas(n)=='Low'
        for m = 2:10
            if CFP.PopDen_Class (n) ==m
               y3(m-1) = y3(m-1) + CFP.Ones(n);
            end
        end
    end
end

escalera(x,[y1,y2,y3])


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)
axis([1 11 0 45])

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height])
box on
lgd= legend('High','Medium', 'Low');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 3
xlabel('Population density   [people/km^2]', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');


set(gca, 'xtick', (2:10));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\PopDen_Disadvantage'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\PopDensity\EPS\PopDen_Disadvantage'); %<-Save as PDF with 300 DPI

