%% COASTALRES ANALYSIS: COASTAL FLOODPLAIN - PU - EUCLIDEAN ALLOCATION FLOODPLAIN %%    

%% Date: 13/04/2020 %%

%% POPULATION %%

%% Population vs SMP short term
CFP.Pop_Class (CFP.Pop_Class==0)= nan;
CFP.Pop_Class (CFP.Pop_Class==1)= nan;

x1= CFP.Pop_Class (CFP.policy_20== 'HTL');
x2= CFP.Pop_Class (CFP.policy_20== 'MR');
x3= CFP.Pop_Class (CFP.policy_20== 'NAI');

hold on
h1= histogram(x1, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h2= histogram(x2,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h3= histogram(x3, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h4= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');

set(h1,'EdgeColor',[0,0,0]/255, 'linestyle', '-');
set(h2,'EdgeColor',[127,127,127]/255, 'linestyle', '-.');
set(h3,'EdgeColor',[150,150,150]/255, 'linestyle', ':');

box on
legend('boxoff');
legend('Location', 'southoutside');
xlabel('Population', 'fontweight', 'bold');
ylabel('Policy Units', 'fontweight', 'bold');
%title({'Total population by SMP policies', 'Short-Term: 20 years'}, 'fontsize', 14);

set(gca, 'xtick', (2:13));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '6400-12800', '12800-25600', '25600-51200', '> 51200'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpdf', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_ST'); %<-Save as PDF with 300 DPI
print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_ST'); %<-Save as PDF with 300 DPI

%% Pop vs SMP long term

CFP.Pop_Class (CFP.Pop_Class==0)= nan;
CFP.Pop_Class (CFP.Pop_Class==1)= nan;

x1= CFP.Pop_Class (CFP.policy_100== 'HTL');
x2= CFP.Pop_Class (CFP.policy_100== 'MR');
x3= CFP.Pop_Class (CFP.policy_100== 'NAI');

hold on
h1= histogram(x1, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h2= histogram(x2,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h3= histogram(x3, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
set(h1,'EdgeColor',[0,0,0]/255, 'linestyle', '-');
set(h2,'EdgeColor',[127,127,127]/255, 'linestyle', '-.');
set(h3,'EdgeColor',[150,150,150]/255, 'linestyle', ':');

h4= legend('Hold-the-Line','Managed Realignment', 'No Active Intervention');
legend('boxoff');
xlabel('Population', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');
%title({'Total population by SMP policy', 'Long-Term: 100 years'}, 'fontsize',14);

set(gca, 'xtick', (2:13));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '6400-12800', '12800-25600', '25600-51200', '> 51200'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpdf', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_LT'); %<-Save as PDF with 300 DPI
print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_LT'); %<-Save as PDF with 300 DPI

%% Population by SMP policies: HTL

x1= CFP.Pop_Class (CFP.policy_20=='HTL');
x2= CFP.Pop_Class (CFP.policy_100=='HTL');

hold on
h1= histogram(x1, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h2= histogram(x2,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);
set(h1,'EdgeColor',[0,0,0]/255);
set(h2,'EdgeColor',[255,0,0]/255);

h3= legend('Short-Term: 20 yrs','Long-Term: 100 yrs');
legend('boxoff');
xlabel('Population', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');
%title('Population by SMP policies: Hold-the-Line', 'fontsize', 14);

set(gca, 'xtick', (2:13));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '6400-12800', '12800-25600', '25600-51200', '> 51200'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpdf', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_HTL'); %<-Save as PDF with 300 DPI
print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_HTL'); %<-Save as PDF with 300 DPI

%% Population by SMP policies: MR

x1= CFP.Pop_Class (CFP.policy_20=='MR');
x2= CFP.Pop_Class (CFP.policy_100=='MR');

hold on
h1= histogram(x1, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h2= histogram(x2,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);
set(h1,'EdgeColor',[0,0,0]/255);
set(h2,'EdgeColor',[255,0,0]/255);

h3= legend('Short-Term: 20 yrs','Long-Term: 100 yrs');
legend('boxoff');
xlabel('Population', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');
%title('Population by SMP policies: Managed Realignment', 'fontsize', 14);

set(gca, 'xtick', (2:13));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '6400-12800', '12800-25600', '25600-51200', '> 51200'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpdf', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_MR'); %<-Save as PDF with 300 DPI
print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_MR'); %<-Save as PDF with 300 DPI

%% Population by SMP policies: NAI

x1= CFP.Pop_Class (CFP.policy_20=='NAI');
x2= CFP.Pop_Class (CFP.policy_100=='NAI');

hold on
h1= histogram(x1, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h2= histogram(x2,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);
set(h1,'EdgeColor',[0,0,0]/255);
set(h2,'EdgeColor',[255,0,0]/255);

h3= legend('Short-Term: 20 yrs','Long-Term: 100 yrs');
legend('boxoff');
xlabel('Population', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');
%title('Population by SMP policies: No Active Intervention',  'fontsize', 14);

set(gca, 'xtick', (2:13));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '6400-12800', '12800-25600', '25600-51200', '> 51200'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpdf', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_NAI'); %<-Save as PDF with 300 DPI
print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_NAI'); %<-Save as PDF with 300 DPI

%% Population by defences

CFP.Pop_Class (CFP.Pop_Class==0)= nan;
CFP.Pop_Class (CFP.Pop_Class==1)= nan;

x1= CFP.Pop_Class (CFP.Def_Type=='Natural');
x2= CFP.Pop_Class (CFP.Def_Type=='Engineered');
x3= CFP.Pop_Class (CFP.Def_Type=='Combo');


hold on
h1= histogram(x1, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h2= histogram(x2,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h3= histogram(x3,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);
set(h1,'EdgeColor',[0,0,0]/255, 'linestyle', '-');
set(h2,'EdgeColor',[127,127,127]/255, 'linestyle', '-.');
set(h3,'EdgeColor',[150,150,150]/255, 'linestyle', ':');

h4= legend('Natural','Engineered', 'Combo');
legend('boxoff');
xlabel('Population', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');
%title('Population by defence type', 'fontsize', 14);

set(gca, 'xtick', (2:13));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '6400-12800', '12800-25600', '25600-51200', '> 51200'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpdf', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_Defences'); %<-Save as PDF with 300 DPI
print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_Defences'); %<-Save as PDF with 300 DPI

%% Population by risk of flooding

x1= CFP.Pop_Class (CFP.Flood=='High');
x2= CFP.Pop_Class (CFP.Flood=='Medium');
x3= CFP.Pop_Class (CFP.Flood=='Low');

hold on
h1= histogram(x1, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h2= histogram(x2, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h3= histogram(x3, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
set(h1,'EdgeColor',[255,0,0]/255);
set(h2,'EdgeColor',[127,127,127]/255);
set(h3,'EdgeColor',[0,0,0]/255);

h4= legend('High likelihood','Medium likelihood', 'Low likelihood');
legend('boxoff');
xlabel('Population', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');
%title('Population by risk of flooding', 'fontsize', 14);

set(gca, 'xtick', (2:13));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '6400-12800', '12800-25600', '25600-51200', '> 51200'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpdf', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_Flood'); %<-Save as PDF with 300 DPI
print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_Flood'); %<-Save as PDF with 300 DPI

%% Population by shoreline change

x1= CFP.Pop_Class (CFP.Erosion< -0.5);
x2= CFP.Pop_Class (CFP.Erosion>= -0.5 & CFP.Erosion< 0.5);
x3= CFP.Pop_Class (CFP.Erosion>= 0.5);

hold on
h1= histogram(x1, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h2= histogram(x2,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h3= histogram(x3,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);

set(h1,'EdgeColor',[255,0,0]/255);
set(h2,'EdgeColor',[127,127,127]/255);
set(h3,'EdgeColor',[0,0,0]/255);

h4= legend('Erosion <-0.5 m/yr','Stable -0.5 to 0.5 m/yr', 'Accretion >0.5 m/yr');
legend('boxoff');
xlabel('Population', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');
%title('Population by shoreline change', 'fontsize', 14);

set(gca, 'xtick', (2:13));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '6400-12800', '12800-25600', '25600-51200', '> 51200'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpdf', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_ShChange'); %<-Save as PDF with 300 DPI
print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_ShChange'); %<-Save as PDF with 300 DPI

%% Population by shoreline change

x1= CFP.Pop_Class (CFP.Erosion< -3);
x2= CFP.Pop_Class (CFP.Erosion>= -3 & CFP.Erosion< -1);
x3= CFP.Pop_Class (CFP.Erosion>= -1 & CFP.Erosion< -0.5);

hold on
h1= histogram(x1, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h2= histogram(x2,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h3= histogram(x3,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);

set(h1,'EdgeColor',[255,0,0]/255);
set(h2,'EdgeColor',[127,127,127]/255);
set(h3,'EdgeColor',[0,0,0]/255);

h4= legend('Extreme erosion <-3 m/yr','Intense erosion -3 to -1 m/yr', 'Erosion -1 to -0.5 m/yr');
legend('boxoff');
xlabel('Population', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');
%title('Population by shoreline change', 'fontsize', 14);

set(gca, 'xtick', (2:13));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '6400-12800', '12800-25600', '25600-51200', '> 51200'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpdf', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_Erosion'); %<-Save as PDF with 300 DPI
print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_Erosion'); %<-Save as PDF with 300 DPI

%% Population by disadvantage

x1= CFP.Pop_Class (CFP.Disadvanta> 0.5);
x2= CFP.Pop_Class (CFP.Disadvanta>= -0.5 & CFP.Disadvanta< 0.5);
x3= CFP.Pop_Class (CFP.Disadvanta<- 0.5);

hold on
h1= histogram(x1, 'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h2= histogram(x2,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);
h3= histogram(x3,  'DisplayStyle', 'stairs', 'LineWidth', 1.75);

set(h1,'EdgeColor',[255,0,0]/255);
set(h2,'EdgeColor',[127,127,127]/255);
set(h3,'EdgeColor',[0,0,0]/255);


h4= legend('High disadvantage','Medium disadvantage', 'Low disadvantage');
legend('boxoff');
xlabel('Population', 'fontweight', 'bold');
ylabel('Policy Units','fontweight', 'bold');
%title('Population by disadvantage index', 'fontsize', 14);

set(gca, 'xtick', (2:13));
xticklabels({'25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '6400-12800', '12800-25600', '25600-51200', '> 51200'})
set(gca, 'XTickLabelRotation', 45);
set(gca, 'FontName', 'Arial', 'FontSize', 11)

print(gcf, '-dpdf', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_Disadvantage'); %<-Save as PDF with 300 DPI
print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Desktop\CoastalRes_CoastalFloodplain\CoastalRes_CoastalFloodplain\Matlab\Plots\Pop_Disadvantage'); %<-Save as PDF with 300 DPI

