%% COASTALRES ANALYSIS: COASTAL FLOODPLAIN - PU - EUCLIDEAN ALLOCATION FLOODPLAIN %%    

%% Date: 17/04/2020 %%

%% OTHERS %%
CFP2= CFP(CFP.Eng_Perc_Class~=-1,:);

LD2= CFP2(CFP2.Disad_Clas=='Low',:);
HD2= CFP2(CFP2.Disad_Clas=='High',:);

%% Scatter plot SHORELINE CHANGE vs % ENG DEFENCES by DI

set(0,'DefaultLegendAutoUpdate','off')

g1= findgroups(HD2.Eng_Perc_Class);
g2= findgroups(LD2.Eng_Perc_Class);

x1= HD2.Eng_Perc_Class;
y1= HD2.ChangeRate;
x2= LD2.Eng_Perc_Class;
y2= LD2.ChangeRate;

x3= unique(HD2.Eng_Perc_Class);
y3= splitapply(@median, HD2.ChangeRate,g1);
sz3= splitapply(@sum, HD2.Length_CFP,g1)*2;
x4= unique(LD2.Eng_Perc_Class);
y4= splitapply(@median, LD2.ChangeRate,g2);
sz4= splitapply(@sum, LD2.Length_CFP,g2)*2;

hold on
s1=scatter(x1,y1);
s2=scatter(x2,y2);
s3=scatter(x3,y3,sz3);
s4=scatter(x4,y4,sz4);
set(s1,'MarkerEdgeColor',[255,127,127]/255, 'MarkerFaceColor',[255,127,127]/255, 'MarkerEdgeAlpha', 0.2, 'MarkerFaceAlpha', 0.2);
set(s2,'MarkerEdgeColor',[127,127,127]/255, 'MarkerFaceColor',[127,127,127]/255, 'MarkerEdgeAlpha', 0.2, 'MarkerFaceAlpha', 0.2);
set(s3,'MarkerEdgeColor',[1,0,0], 'MarkerFaceColor',[1,0,0]);
set(s4,'MarkerEdgeColor',[0,0,0], 'MarkerFaceColor',[0,0,0]);

set(gca, 'xtick', (0:12));
xticklabels({'0','10','20', '30','40','50','60','70','80', '90', '100'})

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend([s3,s4],'High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2;
set(gca, 'FontName', 'Arial', 'FontSize', 11)
h6= ylabel('Shoreline change rate   [m/yr]','fontweight', 'bold');
h7= xlabel ('Percentage of engineered defences','fontweight', 'bold');
axis([-0.5 10.5 -4 4])
% yticks([ -2.5 -2 -1.5 -1 -0.5 0 0.5 1 1.5 2 2.5 3])
ll = yline(0.5,'--','Accretion','LineWidth',1, 'fontweight', 'bold');
l2 = yline(-0.5,'--','Erosion','LineWidth',1, 'fontweight', 'bold');
l2.LabelVerticalAlignment = 'bottom';

print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\ErosionPU_EngDefences'); %<-Save as PDF with 300 DPI
print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\EPS\ErosionPU_EngDefences'); %<-Save as PDF with 300 DPI


%% ENG PERC vs POP DEN

g1= findgroups(HD2.PopDen_Class);
g2= findgroups(LD2.PopDen_Class);

x1=HD2.PopDen_Class;
y1=HD2.Eng_Perc;
x2=LD2.PopDen_Class;
y2=LD2.Eng_Perc;

x3= unique(HD2.PopDen_Class);
y3= splitapply(@mean, HD2.Eng_Perc,g1);
sz3= splitapply(@sum, HD2.Length_CFP,g1)*2;
x4= unique(LD2.PopDen_Class);
y4= splitapply(@mean, LD2.Eng_Perc,g2);
sz4= splitapply(@sum, LD2.Length_CFP,g2)*2;

hold on
s1=scatter(x1,y1);
s2=scatter(x2,y2);
s3=scatter(x3,y3,sz3);
s4=scatter(x4,y4,sz4);
set(s1,'MarkerEdgeColor',[255,127,127]/255, 'MarkerFaceColor',[255,127,127]/255, 'MarkerEdgeAlpha', 0.05, 'MarkerFaceAlpha', 0.05);
set(s2,'MarkerEdgeColor',[127,127,127]/255, 'MarkerFaceColor',[127,127,127]/255, 'MarkerEdgeAlpha', 0.05, 'MarkerFaceAlpha', 0.05);
set(s3,'MarkerEdgeColor',[1,0,0], 'MarkerFaceColor',[1,0,0]);
set(s4,'MarkerEdgeColor',[0,0,0], 'MarkerFaceColor',[0,0,0]);

set(gca, 'xtick', (0:11));
xticklabels({'0','1-25','25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend([s3 s4],'High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2;
h6= ylabel('Percentage of engineered defences','fontweight', 'bold');
h7= xlabel ('Population density   [people/km^2]','fontweight', 'bold');
axis([-0.5 10.5 0 100]);
% 
% print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\EngDefences_PopDen'); %<-Save as PDF with 300 DPI
% print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\EPS\EngDefences_PopDen'); %<-Save as PDF with 300 DPI

%% ENG PERC vs BUILT-UP INTENSITY

g1= findgroups(HD2.Build_Perc_Class);
g2= findgroups(LD2.Build_Perc_Class);

x1=HD2.Build_Perc_Class;
y1=HD2.Eng_Perc;
x2=LD2.Build_Perc_Class;
y2=LD2.Eng_Perc;

x3= unique(HD2.Build_Perc_Class);
y3= splitapply(@median, HD2.Eng_Perc,g1);
sz3= splitapply(@sum, HD2.Length_CFP,g1)*2;
x4= unique(LD2.Build_Perc_Class);
y4= splitapply(@median, LD2.Eng_Perc,g2);
sz4= splitapply(@sum, LD2.Length_CFP,g2)*2;

hold on
s1=scatter(x1,y1);
s2=scatter(x2,y2);
s3=scatter(x3,y3,sz3);
s4=scatter(x4,y4,sz4);
set(s1,'MarkerEdgeColor',[255,127,127]/255, 'MarkerFaceColor',[255,127,127]/255, 'MarkerEdgeAlpha', 0.05, 'MarkerFaceAlpha', 0.05);
set(s2,'MarkerEdgeColor',[127,127,127]/255, 'MarkerFaceColor',[127,127,127]/255, 'MarkerEdgeAlpha', 0.05, 'MarkerFaceAlpha', 0.05);
set(s3,'MarkerEdgeColor',[1,0,0], 'MarkerFaceColor',[1,0,0]);
set(s4,'MarkerEdgeColor',[0,0,0], 'MarkerFaceColor',[0,0,0]);

set(gca, 'xtick', (0:7));
xticklabels({'0','0-5','5-10', '10-15','15-20','20-25','25-30','>30'})
set(gca, 'XTickLabelRotation', 45);

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend([s3 s4],'High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2;
h6= ylabel('Percentage of engineered defences','fontweight', 'bold');
h7= xlabel ('Built-up intensity   [%]','fontweight', 'bold');
axis([-0.5 7.5 0 100]);
% 
% print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\EngDefences_PopDen'); %<-Save as PDF with 300 DPI
% print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\EPS\EngDefences_PopDen'); %<-Save as PDF with 300 DPI


%% Scatter plot SHORELINE CHANGE vs POP DEN  DI

LD= CFP(CFP.Disadvanta<-0.5,:);
HD= CFP(CFP.Disadvanta>0.5,:);

g1= findgroups(HD.PopDen_Class);
g2= findgroups(LD.PopDen_Class);

x1=HD.PopDen_Class;
y1=HD.ChangeRate;
x2=LD.PopDen_Class;
y2=LD.ChangeRate;

% x3= unique(HD.PopDen_Class);
% y3= splitapply(@mean, HD.ChangeRate,g1);
% sz3= splitapply(@sum, HD.Length_CFP,g1)*2;
% x4= unique(LD.PopDen_Class);
% y4= splitapply(@mean, LD.ChangeRate,g2);
% sz4= splitapply(@sum, LD.Length_CFP,g2)*2;
% 
hold on
s1=scatter(x1,y1);
s2=scatter(x2,y2);
% s3=scatter(x3,y3,sz3);
% s4=scatter(x4,y4,sz4);
% set(s1,'MarkerEdgeColor',[255,127,127]/255, 'MarkerFaceColor',[255,127,127]/255, 'MarkerEdgeAlpha', 0.2, 'MarkerFaceAlpha', 0.2);
% set(s2,'MarkerEdgeColor',[127,127,127]/255, 'MarkerFaceColor',[127,127,127]/255, 'MarkerEdgeAlpha', 0.2, 'MarkerFaceAlpha', 0.2);
set(s1,'MarkerEdgeColor',[1,0,0], 'MarkerFaceColor',[1,0,0]);
set(s2,'MarkerEdgeColor',[0,0,0], 'MarkerFaceColor',[0,0,0]);

set(gca, 'xtick', (0:11));
xticklabels({'0','1-25','25-50', '50-100','100-200','200-400','400-800','800-1600','1600-3200', '3200-6400', '> 6400'})
set(gca, 'XTickLabelRotation', 45);

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend([s1 s2],'High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2;
h6= ylabel('Shoreline change rate   [m/yr]','fontweight', 'bold');
h7= xlabel ('Population density   [people/km^2]','fontweight', 'bold');
axis([-0.5 10.5 -4 4]);
ll = yline(0.5,'--','Accretion','LineWidth',1, 'fontweight', 'bold');
l2 = yline(-0.5,'--','Erosion','LineWidth',1, 'fontweight', 'bold');
l2.LabelVerticalAlignment = 'bottom';

% print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\ErosionPU_PopDen'); %<-Save as PDF with 300 DPI
% print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\EPS\ErosionPU_PopDen'); %<-Save as PDF with 300 DPI

%% Scatter plot SHORELINE CHANGE vs Buildup class

LD= CFP(CFP.Disadvanta<-0.5,:);
HD= CFP(CFP.Disadvanta>0.5,:);

g1= findgroups(HD.Build_Perc_Class);
g2= findgroups(LD.Build_Perc_Class);

x1=HD.Build_Perc_Class;
y1=HD.ChangeRate;
x2=LD.Build_Perc_Class;
y2=LD.ChangeRate;

% x3= unique(HD.Build_Perc_Class);
% y3= splitapply(@median, HD.ChangeRate,g1);
% sz3= splitapply(@sum, HD.Length_CFP,g1)*2;
% x4= unique(LD.Build_Perc_Class);
% y4= splitapply(@median, LD.ChangeRate,g2);
% sz4= splitapply(@sum, LD.Length_CFP,g2)*2;

hold on
s1=scatter(x1,y1);
s2=scatter(x2,y2);
% s3=scatter(x3,y3,sz3);
% s4=scatter(x4,y4,sz4);
% set(s1,'MarkerEdgeColor',[255,127,127]/255, 'MarkerFaceColor',[255,127,127]/255, 'MarkerEdgeAlpha', 0.2, 'MarkerFaceAlpha', 0.2);
% set(s2,'MarkerEdgeColor',[127,127,127]/255, 'MarkerFaceColor',[127,127,127]/255, 'MarkerEdgeAlpha', 0.2, 'MarkerFaceAlpha', 0.2);
set(s1,'MarkerEdgeColor',[1,0,0], 'MarkerFaceColor',[1,0,0]);
set(s2,'MarkerEdgeColor',[0,0,0], 'MarkerFaceColor',[0,0,0]);

set(gca, 'xtick', (0:7));
xticklabels({'0','0-5','5-10', '10-15','15-20','20-25','25-30','>30'})
set(gca, 'XTickLabelRotation', 45);

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend([s1 s2],'High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2;
h6= ylabel('Shoreline change rate   [m/yr]','fontweight', 'bold');
h7= xlabel ('Builtup intensity  [%]','fontweight', 'bold');
axis([-0.5 7.5 -4 4]);
ll = yline(0.5,'--','Accretion','LineWidth',1, 'fontweight', 'bold');
l2 = yline(-0.5,'--','Erosion','LineWidth',1, 'fontweight', 'bold');
l2.LabelVerticalAlignment = 'bottom';

% print(gcf, '-dpng', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\ErosionPU_PopDen'); %<-Save as PDF with 300 DPI
% print(gcf, '-deps', '-r300', 'C:\Users\Sofia\Dropbox\CR\Plots\Scatter\EPS\ErosionPU_PopDen'); %<-Save as PDF with 300 DPI
