%% ENG PERC vs BUILT-UP INTENSITY
CFP2= CFP(CFP.Eng_Perc_Class~=-1,:);
CFP2= CFP2(CFP2.Erosion~='NA',:);
CFP2= CFP2(CFP2.ChangeRate>-3 & CFP2.ChangeRate<=3,:);
HD= CFP2(CFP2.Disad_Clas=='High',:);
LD= CFP2(CFP2.Disad_Clas=='Low',:);

%%
x1=HD.Build_Perc_Class;
y1=HD.Eng_Perc;
c1=HD.ChangeRate;
x2=LD.Build_Perc_Class;
y2=LD.Eng_Perc;
c2=LD.ChangeRate;

hold on
s1=scatter(x1,y1,[],c1, 'filled');
s2=scatter(x2,y2,[],c2,'filled','d');
s1.LineWidth=0.6;
s1.MarkerEdgeColor=[0,0,0];
s2.LineWidth=0.6;
s2.MarkerEdgeColor=[0,0,0];
cm= colormap (parula);
cb= colorbar;
% cb.Ticks= [1,2,3];
% cb.TickLabels= {'Erosion','Stable','Accretion'};

set(gca, 'xtick', (0:7));
xticklabels({'0','0-5','5-10', '10-15','15-20','20-25','25-30','>30'})
set(gca, 'XTickLabelRotation', 45);

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend('High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2;
h6= ylabel('Percentage of engineered defences','fontweight', 'bold');
h7= xlabel ('Built-up intensity   [%]','fontweight', 'bold');
axis([-0.5 7.5 0 100]);
%%
x1=HD.Build_Perc_Class;
y1=HD.Eng_Perc;
c1=HD.ChangeRate;
x2=LD.Build_Perc_Class;
y2=LD.Eng_Perc;
c2=LD.ChangeRate;

hold on
s1=scatter(x1,y1,[],c1, 'filled');
s2=scatter(x2,y2,[],c2,'filled','d');
s1.LineWidth=0.6;
s1.MarkerEdgeColor=[0,0,0];
s2.LineWidth=0.6;
s2.MarkerEdgeColor=[0,0,0];
cm= colormap (jet);
cb= colorbar;
% cb.Ticks= [1,2,3];
% cb.TickLabels= {'Erosion','Stable','Accretion'};

set(gca, 'xtick', (0:7));
xticklabels({'0','0-5','5-10', '10-15','15-20','20-25','25-30','>30'})
set(gca, 'XTickLabelRotation', 45);

x0=0;
y0=0;
width=15;
height=15;
set(gcf,'units','centimeters','position',[x0,y0,width,height]);
box on;
lgd= legend('High disadvantage','Low disadvantage');
legend('boxoff');
legend('Location','southoutside');
lgd.NumColumns = 2;
h6= ylabel('Percentage of engineered defences','fontweight', 'bold');
h7= xlabel ('Built-up intensity   [%]','fontweight', 'bold');
axis([-0.5 7.5 0 100]);
