%Function for Chapman-Ferraro current density using magnetic field strength
%gradient across the upstream magnetopause.

function [j_CFx,j_CFy,j_CFz,j_CF] = Chapman_Ferraro_current_density(BJx,BJy,BJz,BGx,BGy,BGz,Xplot,Yplot,Zplot)

%Define permeability of free space
mu_0 = 4*pi*10^-7;

%Calculate gradient for inward-pointing magnetopause normal vectors
delta_Bx = (BGx-BJx)*10^-9; 
delta_By = (BGy-BJy)*10^-9;
delta_Bz = (BGz-BJz)*10^-9;

%Compute normal vectors then the C-F current.
[Nx,Ny,Nz] = surfnorm(Xplot,Yplot,Zplot);
j_CFx = -(1./mu_0)*(delta_By.*Nz - delta_Bz.*Ny);
j_CFy = -(1./mu_0)*(delta_Bz.*Nx - delta_Bx.*Nz);
j_CFz = -(1./mu_0)*(delta_Bx.*Ny - delta_By.*Nx);
j_CF = sqrt(j_CFx.^2 + j_CFy.^2 + j_CFz.^2);
end