%{
Script for plotting Figure 2 (Chapman-Ferraro magnetic field on top-of-ocean spheres
for three extreme Ganymede latitudes inside the Jovian plasma sheet). Each
latitude is viewed from front and back.

Prerequisite: BCF cells generated by running BCF_surface.m at 158, 248,
and 338 deg System-III Jovian east longitude.

Instruction: Run script once to obtain Figure 2.

%}

%Create figure and subplots.
fig = figure('Name','BCF 3D Sphere');
set(fig,'Position',[50,50,1200,2700]);
ha = tight_subplot(2,3,[.15 .05],[.1 .08],[.06 .12]);

%%%% Creating Plottinng BCF Vector Arrays %%%%
%Sample one BCF vector and its position at every 20 grid points.
%Normalize BCF vectors for clarity.
Xm_sam158 = Xmcell{1}(1:20:end,1:20:end);
Ym_sam158 = Ymcell{1}(1:20:end,1:20:end);
Zm_sam158 = Zmcell{1}(1:20:end,1:20:end);
BCFx_sam158 = BCFxcell{1}(1:20:end,1:20:end);
BCFy_sam158 = BCFycell{1}(1:20:end,1:20:end);
BCFz_sam158 = BCFzcell{1}(1:20:end,1:20:end);
BCF_sam158 = BCFcell{1}(1:20:end,1:20:end);
BCFx_usam158 = BCFx_sam158./BCF_sam158; 
BCFy_usam158 = BCFy_sam158./BCF_sam158;
BCFz_usam158 = BCFz_sam158./BCF_sam158;

Xm_sam248 = Xmcell{2}(1:20:end,1:20:end);
Ym_sam248 = Ymcell{2}(1:20:end,1:20:end);
Zm_sam248 = Zmcell{2}(1:20:end,1:20:end);
BCFx_sam248 = BCFxcell{2}(1:20:end,1:20:end);
BCFy_sam248 = BCFycell{2}(1:20:end,1:20:end);
BCFz_sam248 = BCFzcell{2}(1:20:end,1:20:end);
BCF_sam248 = BCFcell{2}(1:20:end,1:20:end);
BCFx_usam248 = BCFx_sam248./BCF_sam248; %normalise BCF vectors
BCFy_usam248 = BCFy_sam248./BCF_sam248;
BCFz_usam248 = BCFz_sam248./BCF_sam248;

Xm_sam338 = Xmcell{3}(1:20:end,1:20:end);
Ym_sam338 = Ymcell{3}(1:20:end,1:20:end);
Zm_sam338 = Zmcell{3}(1:20:end,1:20:end);
BCFx_sam338 = BCFxcell{3}(1:20:end,1:20:end);
BCFy_sam338 = BCFycell{3}(1:20:end,1:20:end);
BCFz_sam338 = BCFzcell{3}(1:20:end,1:20:end);
BCF_sam338 = BCFcell{3}(1:20:end,1:20:end);
BCFx_usam338 = BCFx_sam338./BCF_sam338; %normalise BCF vectors
BCFy_usam338 = BCFy_sam338./BCF_sam338;
BCFz_usam338 = BCFz_sam338./BCF_sam338;   

%%%% Plot BCF in six subplots %%%
%Subplot order goes by columnn, then row i.e., [1,2,3]; [4,5,6]
%Procedure same across latitudes, so only comment on the first.
axes(ha(1)); %158 deg front view.
fig158f = surf(Xmcell{1},Ymcell{1},Zmcell{1},BCFcell{1}); %Plot BCF sphere
set(fig158f,'EdgeColor','none'); %Remove grid
clim([0 65]) %Set color bar limit
hold on %Plot vector over sphere
vfig158f = quiver3(Xm_sam158(:),Ym_sam158(:),Zm_sam158(:),...
    BCFx_usam158(:),BCFx_usam158(:),BCFz_usam158(:)); %Unroll matrices for quiver
vfig158f.Color = 'red';
vfig158f.AutoScaleFactor = 0.75;
vfig158f.LineWidth = 1.50;
vfig158f.MaxHeadSize = 0.60;
axis equal 
hold off
axis equal;
xticks([-1 -0.5 0 0.5 1]) %Set tick positions for 3 axes.
fontsize(gca,18,'Points')
yticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
zticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
xlabel('X (R_G)','Interpreter','tex','FontSize',20); %Set axes labels
ylabel('Y (R_G)','Interpreter','tex','FontSize',20);
zlabel('Z (R_G)','Interpreter','tex','FontSize',20);
set(gca,'XMinorTick','on','YMinorTick','on','ZMinorTick','on') %Add minor ticks.
set(gca,'TickLength',[0.02,0.05]) %Set tick lengths.
title('(a) \lambda_{III} = 158^{o} (Front)','Interpreter','tex','FontSize',24) %Set subplot title.
view([-60 25]); %Set front view angle.

axes(ha(4)); %158 deg back view.
fig158b = surf(Xmcell{1},Ymcell{1},Zmcell{1},BCFcell{1}); %Use same data as front view.
set(fig158b,'EdgeColor','none');
clim([0 65])
hold on
vfig158b = quiver3(Xm_sam158(:),Ym_sam158(:),Zm_sam158(:),...
    BCFx_usam158(:),BCFx_usam158(:),BCFz_usam158(:));
vfig158b.Color = 'red';
vfig158b.AutoScaleFactor = 0.75;
vfig158b.LineWidth = 1.50;
vfig158b.MaxHeadSize = 0.60;
axis equal
hold off
axis equal;
xticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
yticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
zticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
xlabel('X (R_G)','Interpreter','tex','FontSize',20);
ylabel('Y (R_G)','Interpreter','tex','FontSize',20);
zlabel('Z (R_G)','Interpreter','tex','FontSize',20);
set(gca,'XMinorTick','on','YMinorTick','on','ZMinorTick','on')
set(gca,'TickLength',[0.02,0.05])
title('(b) \lambda_{III} = 158^{o} (Back)','Interpreter','tex','FontSize',24)
view([120 25]); %Set back view.

axes(ha(2)) %248 deg front view.
fig248f = surf(Xmcell{2},Ymcell{2},Zmcell{2},BCFcell{2});
set(fig248f,'EdgeColor','none');
clim([0 65])
hold on
vfig248f = quiver3(Xm_sam248(:),Ym_sam248(:),Zm_sam248(:),...
    BCFx_usam158(:),BCFx_usam248(:),BCFz_usam248(:));
vfig248f.Color = 'red';
vfig248f.AutoScaleFactor = 0.75;
vfig248f.LineWidth = 1.50;
vfig248f.MaxHeadSize = 0.60;
axis equal
hold off
axis equal;
xticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
yticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
zticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
xlabel('X (R_G)','Interpreter','tex','FontSize',20);
ylabel('Y (R_G)','Interpreter','tex','FontSize',20);
zlabel('Z (R_G)','Interpreter','tex','FontSize',20);
set(gca,'XMinorTick','on','YMinorTick','on','ZMinorTick','on')
set(gca,'TickLength',[0.02,0.05])
title('(c) \lambda_{III} = 248^{o} (Front)','Interpreter','tex','FontSize',24)
view([-60 25]);

axes(ha(5)); %248 deg back view.
fig248b = surf(Xmcell{2},Ymcell{2},Zmcell{2},BCFcell{2});
set(fig248b,'EdgeColor','none');
clim([0 65])
hold on
vfig248b = quiver3(Xm_sam248(:),Ym_sam248(:),Zm_sam248(:),...
    BCFx_usam158(:),BCFx_usam248(:),BCFz_usam248(:)); %unroll matrix for quiver
vfig248b.Color = 'red';
vfig248b.AutoScaleFactor = 0.75;
vfig248b.LineWidth = 1.50;
vfig248b.MaxHeadSize = 0.60;
axis equal
hold off
axis equal;
xticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
yticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
zticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
xlabel('X (R_G)','Interpreter','tex','FontSize',20);
ylabel('Y (R_G)','Interpreter','tex','FontSize',20);
zlabel('Z (R_G)','Interpreter','tex','FontSize',20);
set(gca,'XMinorTick','on','YMinorTick','on','ZMinorTick','on')
set(gca,'TickLength',[0.02,0.05])
title('(d) \lambda_{III} = 248^{o} (Back)','Interpreter','tex','FontSize',24)
view([120 25]);

axes(ha(3)) %338 deg front view.
fig338f = surf(Xmcell{3},Ymcell{3},Zmcell{3},BCFcell{3});
set(fig338f,'EdgeColor','none');
clim([0 65])
hold on
vfig338f = quiver3(Xm_sam338(:),Ym_sam338(:),Zm_sam338(:),...
    BCFx_usam338(:),BCFx_usam338(:),BCFz_usam338(:)); %unroll matrix for quiver
vfig338f.Color = 'red';
vfig338f.AutoScaleFactor = 0.75;
vfig338f.LineWidth = 1.50;
vfig338f.MaxHeadSize = 0.60;
axis equal
hold off
axis equal;
xticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
yticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
zticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
xlabel('X (R_G)','Interpreter','tex','FontSize',20);
ylabel('Y (R_G)','Interpreter','tex','FontSize',20);
zlabel('Z (R_G)','Interpreter','tex','FontSize',20);
set(gca,'XMinorTick','on','YMinorTick','on','ZMinorTick','on')
set(gca,'TickLength',[0.02,0.05])
title('(e) \lambda_{III} = 338^{o} (Front)','Interpreter','tex','FontSize',24)
view([-60 25]);

axes(ha(6));  %338 deg back view.
fig338b = surf(Xmcell{3},Ymcell{3},Zmcell{3},BCFcell{3});
set(fig338b,'EdgeColor','none');
clim([0 65])
hold on
vfig338b = quiver3(Xm_sam338(:),Ym_sam338(:),Zm_sam338(:),...
    BCFx_usam338(:),BCFx_usam338(:),BCFz_usam338(:)); %unroll matrix for quiver
vfig338b.Color = 'red';
vfig338b.AutoScaleFactor = 0.75;
vfig338b.LineWidth = 1.50;
vfig338b.MaxHeadSize = 0.60;
axis equal
hold off
axis equal;
xticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
yticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
zticks([-1 -0.5 0 0.5 1])
fontsize(gca,18,'Points')
xlabel('X (R_G)','Interpreter','tex','FontSize',20);
ylabel('Y (R_G)','Interpreter','tex','FontSize',20);
zlabel('Z (R_G)','Interpreter','tex','FontSize',20);
set(gca,'XMinorTick','on','YMinorTick','on','ZMinorTick','on')
set(gca,'TickLength',[0.02,0.05]) %default [0.01,0.025] [2D,3D]
title('(f) \lambda_{III} = 338^{o} (Back)','Interpreter','tex','FontSize',24)
view([120 25]);

%Set common color bar based on data at lambda3 = 338 deg.
c3 = colorbar;
c3.Position = [0.92 0.05 0.01 0.9]; %Set color bar position
c3.Label.String = 'B_{CF} (nT)'; %Set color bar label
c3.FontSize = 20;
c3.Limits = [0 65]; %Set color bar limit. Have to be the same as clim in all subplots.

%Save Figure
filename = strcat('BCFsph','_y',string(ymax),'z',string(zmax),'.png'); %Set file name
removeToolbarExplorationButtons(fig) %Remove Matlab toolbars
exportgraphics(fig,filename,'Resolution',500) %Export figure.
