%Script for generating surface area grids for Biot-Savart integration
%on magnetopause flank surfaces.
%IMPORTANT: make sure input grids do not overlap between half-cylindrical and flank sections

%Take as input magnetopause grid produced from MPex.m
function [dSgrid_aj,dSgrid_sj] = dSgridEx(grad_aj,grad_sj,Nex,res_ex)

%Set up dS grids
dSgrid_aj = NaN(length(grad_aj),Nex);
dSgrid_sj = NaN(length(grad_sj),Nex); 

%Compute dSgrid. There is no need for Jacobian as flank extensions are flat.
for i = 1:length(grad_aj)
    for j = 1:Nex
        dSgrid_aj(i,j) = sqrt(1+grad_aj(i,1)^2)*res_ex*res_ex;
        dSgrid_sj(i,j) = sqrt(1+grad_sj(i,1)^2)*res_ex*res_ex;
        %dS in unit of res squared
    end        
end

end