%Function to derive magnetic field components draping along the Jovian-side magnetopause.

%Take as input upstream Jovian magnetic field, magnetic pressure near
%magnetopause, and the magnetopause grid.
function [BJx,BJy,BJz,BJ] = jovian_field_boundary(Bx_up,By_up,Bz_up,Pbb,Xplot,Yplot,Zplot)

%Calculate magnetic field strength at Jovian-side magnetopause from
%magnetic pressure.
Pbb = Pbb*10^-9;
BJ = sqrt(2*4*pi*10^-7.*Pbb);  
BJ = BJ*10^9;

%Project upstream Jovian field vector onto the magnetopause at each grid point.
[Nx,Ny,Nz] = surfnorm(Xplot,Yplot,Zplot); %Calculate normal vectors
dot = (Bx_up.*Nx) + (By_up.*Ny) + (Bz_up.*Nz); 
BJxb = Bx_up - dot.*Nx; %Project three components
BJyb = By_up - dot.*Ny;
BJzb = Bz_up - dot.*Nz;
BJb = sqrt(BJxb.^2+BJyb.^2+BJzb.^2); %Normalize direction vectors.
BJx_dir = BJxb./BJb;
BJy_dir = BJyb./BJb;
BJz_dir = BJzb./BJb;

%Obtain final vector by multiplying field strength with direction vectors.
BJx = BJ.*BJx_dir;
BJy = BJ.*BJy_dir;
BJz = BJ.*BJz_dir;

end