%Function to calculate Jovian velocity parallel to the magnetopause.

function [vJx,vJy,vJz,vJ] = jovian_vel_boundary(vJ0,Xplot,Yplot,Zplot,alpha,y,z)

%Calculate flow speed parallel to the magnetopause.
vJ = vJ0*sind(alpha);

%Calculate cross product of initial flow and normal surface vectors
v0_uvec = [vJ0,0.0,0.0]/vJ0;
[Nx,Ny,Nz] = surfnorm(Xplot,Yplot,Zplot);

Cx = NaN(size(Xplot));
Cy = NaN(size(Yplot));
Cz = NaN(size(Zplot));
for i = 1:length(Xplot(:,1))
    for j = 1:length(Xplot(1,:))
          C = cross(v0_uvec,[Nx(i,j),Ny(i,j),Nz(i,j)]);
          Cx(i,j) = C(1);
          Cy(i,j) = C(2);
          Cz(i,j) = C(3);
    end
end

%Calculate intermediate arrays, then normalized velocity components
A1 = Nx - Nz.*Cx./Cz;
A2 = Ny - Nz.*Cy./Cz;
A3 = 1 + (A1./A2).^2 + ((Cx - Cy.*(A1./A2))./(Cz)).^2;
vJux = sqrt(1./A3);
vJuy = -1*vJux.*(A1./A2);
vJuz = (-1./Cz).*(vJux.*Cx + vJuy.*Cy);

%Note that at y = 0, Cz = 0 so A1, A2 are now NaN.
%To solve this use rearrangement to write
A1(:,y==0) = Nx(:,y==0) - Ny(:,y==0).*Cx(:,y==0)./Cy(:,y==0);
A2(:,y==0) = Nz(:,y==0) - Ny(:,y==0).*Cz(:,y==0)./Cy(:,y==0);
A3(:,y==0) = 1 + (A1(:,y==0)./A2(:,y==0)).^2 + ((Cx(:,y==0) - Cz(:,y==0).*(A1(:,y==0)./A2(:,y==0)))./(Cy(:,y==0))).^2;
vJux(:,y==0) = sqrt(1./A3(:,y==0));
vJuz(:,y==0) = -1*vJux(:,y==0).*(A1(:,y==0)./A2(:,y==0));
vJuy(:,y==0) = (-1./Cy(:,y==0)).*(vJux(:,y==0).*Cx(:,y==0) + vJuz(:,y==0).*Cz(:,y==0));

%At subflow point, flow stagnates.
vJux(z == 0, y == 0) = 0.0;
vJuy(z == 0, y == 0) = 0.0;
vJuz(z == 0, y == 0) = 0.0;

%Compute final velocity vectors.
vJx = vJ.*vJux;
vJy = vJ.*vJuy;
vJz = vJ.*vJuz;

end