%Function to calculate upstream magnetic pressure based on field input.
%Input and output are both in nT.

function Pb = magnetic_pressure(Bx,By,Bz)
B = sqrt(Bx.^2+By.^2+Bz.^2);
B = B*10^-9;

Pb = B.^2/(2*4*pi*10^-7);
Pb = Pb*10^9;
end