%Function to calculate magnetic pressure at the Jovian-side magnetopause.

%Take as input upstream magnetic/plasma/dynamical pressures and
%plasma/dynamical pressures at magnetopause.
function Pbb = magnetic_pressure_boundary(Pb_up,Pp_up,Pram_up,PJr,PJp)

%Compute total pressure upstream
Ptot = Pb_up + Pp_up + Pram_up;

%Use pressure conservation to find magnetic pressure at magnetopause. 
Pbb = Ptot - PJr - PJp;

end