%Function to calculate Jovian plasma pressure acting on the magnetopause.
%Plasma pressure combines thermal and energetic plasma populations.
%Pressure is calculated in nPa.

%Take as input upstream plasma pressure and flaring angle
function Ppb = plasma_pressure(Pp_up,alpha)

%Set compression factor based on Petrinec and Russell, 1997.
B1 = 1.0528; 

%Calculate compressed pressure on Jovian-side magnetopause.
delta_p = B1*abs(cosd(alpha));
Ppb = Pp_up + delta_p;

end