%Script for plotting Figure 3 (BCF evolution over Jovian synodic period).
%Each run of this script generates one subplot at specified measurement latitude.

%Choose latitude to plot (in deg) 
lat = 0;

%Reformat BCF field strength array from 3D to cells each containing 1D BCF data over time.
%Cells are differentiated by longitude.
for k = 1:length(lon_list)
    for w = 1:length(lambda3_array)
    BCF_cell{k}(w) = BCF_array(lat_list==lat,k,w);
    lon_num{k} = lon_list(k);
    end
end    

%Generate plot for each measurement latitude.
%Set up figure.
fig = figure('Position',[100,50,1000,700]);
xlim([0 360]) %Define x-axis for one synodic period.
xticks([0 90 180 270 360])
xticklabels({'0^{o}','90^{o}','180^{o}','270^{o}','360^{o}'})
fontsize(gca,24,'Points')
ylim([0 80]) %Define y-axis for BCF range.
yticks([0 20 40 60 80])
yticklabels({'0','20','40','60','80'})
fontsize(gca,24,'Points')
set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'TickLength',[0.02,0.05])
xlabel('\lambda_{III} (deg)','Interpreter','tex','FontSize',30);
ylabel('B_{CF} (nT)','Interpreter','tex','FontSize',30);

%Loop over cells to plot evolution lines at different Ganymedean longitudes.
hold on
for k = 1:numel(BCF_cell)
    p{k} = plot(lambda3_array,BCF_cell{k},'Linewidth',2);
    legendinfo{k} = [sprintf('\\phi = %d^\\circ',lon_num{k})]; %Set up legend. Double \\ needed for backslash.
end
hold off

%Format legend and plot labels.
lgd = legend(legendinfo,'Location','northeast','Interpreter','tex');
fontsize(lgd,24,'points')
text(10,77,sprintf('\\Lambda = %d^\\circ',lat),'FontSize',30,'FontWeight','bold')
%Note: can add subplot letter label in above line.

%Save figure.
lambda3res = round(360./(length(lambda3_array)-1),1); %Set System-III longitude as string name.
filename = strcat('BCFevo_lat',string(lat),'_lr',string(lambda3res),'_y',string(ymax),'z',string(zmax),'.png'); %Set file name.
removeToolbarExplorationButtons(fig) %Remove Matlab toolbars
exportgraphics(fig,filename,'Resolution',500) %Export figure.