%Function for dynamical (ram) pressure based on plasma density and velocity
%both upstream of the magnetopause and along the boundary itself.

function [Pr_up, PJr] = dynamical_pressure(rho0,vJ0,rho,vpx,vpy,vpz) 
%Densities in amu/cm^-3, Velocities in km/s

%Compute dynamical pressure upstream of the magnetopause
rho0 = rho0*(10^6)*(1.67*10^-27);  %Convert density to kgm^-3
rho0_grid = rho0*ones(length(rho(:,1)),length(rho(1,:))); %Create density grid
vJ0 = vJ0*1000; %Convert velocity to m/s
v0_grid = vJ0*ones(length(rho(:,1)),length(rho(1,:))); %Make velocity grid
Pr_up = rho0_grid.*(v0_grid.^2); %Obtain dynamical pressure
Pr_up = Pr_up*10^9; %Convert pressure to nPa

%Compute dynamical pressure along the magnetopause.
%Same procedure as above, but with grids already established.
rho = rho*(10^6)*(1.67*10^-27);
vp = sqrt(vpx.^2+vpy.^2+vpz.^2);
vp = vp*1000;
PJr = rho.*(vp.^2);
PJr = PJr*10^9;
end