%Function to calculate flaring angle between inflowing Jovian plasma and
%each magnetopause grid point. Angle is calculated in degrees.

function alpha = flaring_angle(Xplot,Yplot,Zplot,vJ0)

%Calculate normalized magnetopause normal vectors
[Nx,Ny,Nz] = surfnorm(Xplot,Yplot,Zplot); 
row = length(Xplot(:,1));
col = length(Xplot(1,:));

%Form Jovian plasma inflow vectors
v0x = vJ0*ones(row,col);
v0y = zeros(row,col);
v0z = zeros(row,col);

%Calculate flaring angle through dot product.
v0mag = sqrt((v0x).^2+(v0y).^2+(v0z).^2);
Nmag = sqrt(Nx.^2+Ny.^2+Nz.^2);
dot = (v0x.*Nx) + (v0y.*Ny) + (v0z.*Nz);
mag = v0mag.*Nmag;
alpha = acosd(dot./mag);

end