%Function to calculate Ganymede field strength required to balance Jovian 
%acting pressure at the magnetopause. Assume cold, stagnant plasma inside boundary.

function [BGx,BGy,BGz,BG] = ganymede_field_boundary(PJtot,Xplot,Yplot,Zplot,z,z_ocfb)

%Compute Ganymedean field strength matching acting pressure.
PJtot = PJtot*10^-9; %Convert to Pa first
BG = sqrt(2*4*pi*10^-7*PJtot);
BG = BG*10^9; %Convert to nT

%Calculate local magnetopause normal vectors
[Nx,Ny,Nz] = surfnorm(Xplot,Yplot,Zplot);

%Calculate Ganymedean field direction parallel to the magnetopause. Assume
%internal field is dipolar and use linear equations to find three-component solutions.
A1 = 1 + (Yplot./Xplot).^2; %Define intermediate arrays
A2 = (Nx + (Yplot./Xplot).*Ny);
A3 = (A1./(A2.^2)).*(Nz.^2) + 1;

row = length(Xplot(:,1));
col = length(Xplot(1,:));
BGuz = NaN(row,col);

%Define normalized Z-component in open- and closed-field regions.
for i = 1:row
    for j = 1:col
        if abs(z(i)) < z_ocfb
                BGuz(i,j) = sqrt(1./A3(i,j));
        else
                BGuz(i,j) = -1*sqrt(1./A3(i,j));
        end
    end
end

%Compute normalized X- and Y-components.
BGux = -1*(BGuz.*Nz)./A2;
BGuy = BGux.*(Yplot./Xplot);

%Obtain final Ganymedean magnetic field vectors.
BGx = BGux.*BG;
BGy = BGuy.*BG;
BGz = BGuz.*BG;

end