%Function to compute Jovian plasma mass density compressed at the magnetopause.

%Take as input upstream plasma density and flaring angle.
function rho = jovian_mass_density(rho0,alpha)

%Compression factor based on Jia et al., 2008; Toth et al., 2016.
A = 4;

%Calculate compressed density.
rho_delta = A*abs(cosd(alpha));
rho = rho0 + rho_delta;

end