%Function to generate unit vector upstream Jovian magnetic field direction based on
%System-III Jovian east longitude. Adapted from results of Khurana et al (1997) 
%calculated by Jia et al (2008). GphiO-X component is ignored.

function [Byu,Bzu] = upstream_jovian_field_dir(lambda3)

%Parametrize By and Bz
By = 84*sind(lambda3-248);
Bz = 3*cosd(lambda3-248) - 79;

%Normalized to unit vector
B = sqrt(By^2+Bz^2);
Byu = By/B;
Bzu = Bz/B;

end