%Function to calculate upstream Jovian plasma mass density and pressure from System-III
%Jovian east longitude. Assume Gaussian scaling w.r.t. distance from centrifugal plane

function [rhoJ0, pJ0, BJ0] = upstream_parameters(lambda3,rho248,p248,BJ248,H)
%Calculate Ganymede's vertical distance from centrifugal plane in R_J.
d = 15*sind(6.3)*sind(lambda3-248);

%Calculate upstream plasma density, plasma pressure, and magnetic field.
rhoJ0 = rho248*exp(-(d/H)^2);
pJ0 = p248*exp(-(d/H)^2);
BJ0 = abs(35*sind(lambda3-248))+BJ248;

end