clear;
%%
%data import and preprocessing

fig_cha3_stretch_raw = figure;

% respiration 10k
rc_resp = readmatrix('Parallel_strech.xlsx','Sheet','10k','Range','A22:A201');
belt_resp(:,1) = readmatrix('Parallel_strech.xlsx','Sheet','10k','Range','F2:F137');
% belt_resp(:,2) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','10k','H2:H152');
% belt_resp(:,3) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','10k','J2:J152');

rc_resp = rc_resp * 1e12;

m_resp = movmean(rc_resp,8);


belt_max = islocalmax(belt_resp, 'MinSeparation', 10, 'MinProminence', 1);
belt_min = islocalmin(belt_resp, 'MinSeparation', 10, 'MinProminence', 1);

cap_max = islocalmax(m_resp, 'MinSeparation', 10, 'MinProminence', 0.1);
cap_min = islocalmin(m_resp, 'MinSeparation', 10, 'MinProminence', 0.1);

belt_min(8) = 1;
% belt_min(125) = 0;
belt_max(7) = 0;

cap_min(10) = 1;
cap_max(2) = 0;

seq_belt_max = find(belt_max == 1);
seq_belt_min = find(belt_min == 1);

seq_cap_max = find(cap_max == 1);
seq_cap_min = find(cap_min == 1);

% plot belt measured respiration data
subplot(2,1,1);
t2 = linspace(0,15,136);
% plot(t2,belt_resp);
plot(t2,belt_resp,t2(belt_max),belt_resp(belt_max),'ro', t2(belt_min),belt_resp(belt_min),'bo',"LineWidth", 1);
grid on;
grid minor;

% title('Respiration belt: force')
xlabel({'Time (s)', '(a)'});
ylabel('Force (N)');

% plot impedance analyser measured respiration data
subplot(2,1,2);
t1 = linspace(0,15,180);
% plot(t1,m_resp);
plot(t1,m_resp,t1(cap_max),m_resp(cap_max),'ro', t1(cap_min),m_resp(cap_min),'bo',"LineWidth", 1);
grid on;
grid minor;

% title('Impedance analyser 10kHz: capacitance')
xlabel({'Time (s)', '(b)'});
ylabel('Capacitance (pF)');

% Adjust the size of fig_scaled_C
fig_cha3_stretch_raw.Units = 'centimeters';
fig_cha3_stretch_raw.Position = [1, 1, 15, 15]; % Adjust these values based on your preference



% Save fig_scaled_C as an image (e.g., PNG)
print(fig_cha3_stretch_raw, 'fig_cha3_freq_stretch_raw', '-dpng', '-r300');
%%
% %%
% %data import and preprocessing
% 
% % respiration 1k
% rc_resp = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','400k','A2:C201');
% belt_resp = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','400k','E2:J152');
% 
% rc_resp = rc_resp * 1e12;
% 
% m_resp = movmean(rc_resp,8);
% 
% % plot impedance analyser measured respiration data
% subplot(2,1,1);
% t1 = linspace(0,15,200);
% plot(t1,m_resp)
% grid on
% title('Impedance analyser 400kHz: capacitance')
% xlabel('Time (s)')
% ylabel('Capacitance (pF)')
% 
% % plot belt measured respiration data
% subplot(2,1,2);
% t2 = linspace(0,15,151);
% plot(t2,belt_resp)
% grid on
% title('Respiration belt: force')
% xlabel('Time (s)')
% ylabel('Force (N)')
% %%
% %data import and preprocessing
% 
% % respiration 1k
% rc_resp = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','700k','A2:C201');
% belt_resp = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','700k','E2:J152');
% 
% rc_resp = rc_resp * 1e12;
% 
% m_resp = movmean(rc_resp,8);
% 
% % plot impedance analyser measured respiration data
% subplot(2,1,1);
% t1 = linspace(0,15,200);
% plot(t1,m_resp)
% grid on
% title('Impedance analyser 700kHz: capacitance')
% xlabel('Time (s)')
% ylabel('Capacitance (pF)')
% 
% % plot belt measured respiration data
% subplot(2,1,2);
% t2 = linspace(0,15,151);
% plot(t2,belt_resp)
% grid on
% title('Respiration belt: force')
% xlabel('Time (s)')
% ylabel('Force (N)')
% %%
% %data import and preprocessing
% 
% % respiration 1k
% rc_resp = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','1M','A2:C201');
% belt_resp = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','1M','E2:J152');
% 
% rc_resp = rc_resp * 1e12;
% 
% m_resp = movmean(rc_resp,8);
% 
% % plot impedance analyser measured respiration data
% subplot(2,1,1);
% t1 = linspace(0,15,200);
% plot(t1,m_resp)
% grid on
% title('Impedance analyser 1MHz: capacitance')
% xlabel('Time (s)')
% ylabel('Capacitance (pF)')
% 
% % plot belt measured respiration data
% subplot(2,1,2);
% t2 = linspace(0,15,151);
% plot(t2,belt_resp)
% grid on
% title('Respiration belt: force')
% xlabel('Time (s)')
% ylabel('Force (N)')
% %%
% %data import and preprocessing
% 
% % respiration 1k
% rc_resp = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','2M','A2:C201');
% belt_resp = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','2M','E2:J152');
% 
% rc_resp = rc_resp * 1e12;
% 
% m_resp = movmean(rc_resp,8);
% 
% % plot impedance analyser measured respiration data
% subplot(2,1,1);
% t1 = linspace(0,15,200);
% plot(t1,m_resp)
% grid on
% title('Impedance analyser 2MHz: capacitance')
% xlabel('Time (s)')
% ylabel('Capacitance (pF)')
% 
% % plot belt measured respiration data
% subplot(2,1,2);
% t2 = linspace(0,15,151);
% plot(t2,belt_resp)
% grid on
% title('Respiration belt: force')
% xlabel('Time (s)')
% ylabel('Force (N)')
% %%
% %data import and preprocessing
% 
% % respiration 1k
% rc_resp = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','3M','C2:C201');
% belt_resp = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\Parallel_strech.xlsx','3M','J2:J146');
% 
% rc_resp = rc_resp * 1e12;
% 
% m_resp = movmean(rc_resp,8);
% 
% % plot impedance analyser measured respiration data
% subplot(2,1,1);
% t1 = linspace(0,15,200);
% plot(t1,m_resp)
% grid on
% % title('Impedance analyser 3MHz: capacitance')
% xlabel('Time (s)')
% ylabel('Capacitance (pF)')
% 
% % plot belt measured respiration data
% subplot(2,1,2);
% t2 = linspace(0,15,145);
% plot(t2,belt_resp)
% grid on
% % title('Respiration belt: force')
% xlabel('Time (s)')
% ylabel('Force (N)')
% %%
% freq = [0.01 0.4 0.7 1 2 3];
% 
% % abs cap
% F_vs_freq(:,1) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','10k','D2:D10');
% F_vs_freq(:,2) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','400k','D2:D10');
% F_vs_freq(:,3) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','700k','D2:D10');
% F_vs_freq(:,4) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','1M','D2:D10');
% F_vs_freq(:,5) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','2M','D2:D10');
% F_vs_freq(:,6) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','3M','D2:D10');
% 
% % force
% C_vs_freq(:,1) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','10k','K2:K10');
% C_vs_freq(:,2) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','400k','K2:K10');
% C_vs_freq(:,3) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','700k','K2:K10');
% C_vs_freq(:,4) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','1M','K2:K10');
% C_vs_freq(:,5) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','2M','K2:K10');
% C_vs_freq(:,6) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','3M','K2:K10');
% 
% % plot impedance analyser measured respiration data
% subplot(2,1,1);
% boxplot(F_vs_freq,freq)
% % title('Change in capacitance due to skin stretch')
% xlabel('Frequency (MHz)')
% ylabel('Capacitance(pF)')
% grid on
% 
% % plot belt measured respiration data
% subplot(2,1,2);
% boxplot(C_vs_freq,freq)
% % title('Corresponding respiration belt data')
% xlabel('Frequency (MHz)')
% ylabel('Force(N)')
% grid on
% 
% %%
% freq = [0.01 0.4 0.7 1 2 3];
% 
% % abs cap
% F_vs_freq(:,1) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','10k','F2:F10');
% F_vs_freq(:,2) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','400k','F2:F10');
% F_vs_freq(:,3) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','700k','F2:F10');
% F_vs_freq(:,4) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','1M','F2:F10');
% F_vs_freq(:,5) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','2M','F2:F10');
% F_vs_freq(:,6) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','3M','F2:F10');
% 
% % force
% C_vs_freq(:,1) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','10k','M2:M10');
% C_vs_freq(:,2) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','400k','M2:M10');
% C_vs_freq(:,3) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','700k','M2:M10');
% C_vs_freq(:,4) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','1M','M2:M10');
% C_vs_freq(:,5) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','2M','M2:M10');
% C_vs_freq(:,6) = xlsread('C:\Users\Boyuan Zhao\Desktop\2021 Meeting\Week 22\vs_freq\pa_stretch.xlsx','3M','M2:M10');
% 
% % plot impedance analyser measured respiration data
% subplot(2,1,1);
% boxplot(F_vs_freq,freq)
% % title('Change in capacitance due to skin stretch')
% xlabel('Frequency (MHz)')
% ylabel('Capacitance(pF)')
% grid on
% 
% % plot belt measured respiration data
% subplot(2,1,2);
% boxplot(C_vs_freq,freq)
% % title('Corresponding respiration belt data')
% xlabel('Frequency (MHz)')
% ylabel('Force(N)')
% grid on

%%
fig_cha3_stretch = figure;
freq = [0.01e6 0.4e6 0.7e6 1e6 2e6 3e6];
% freq = [0.01e6 0.4e6 0.7e6 1e6 2e6];

% belt
F_vs_freq(:,1) = readmatrix('pa_stretch.xlsx','Sheet','10k','Range','K2:K10');
F_vs_freq(:,2) = readmatrix('pa_stretch.xlsx','Sheet','400k','Range','K2:K10');
F_vs_freq(:,3) = readmatrix('pa_stretch.xlsx','Sheet','700k','Range','K2:K10');
F_vs_freq(:,4) = readmatrix('pa_stretch.xlsx','Sheet','1M','Range','K2:K10');
F_vs_freq(:,5) = readmatrix('pa_stretch.xlsx','Sheet','2M','Range','K2:K10');
F_vs_freq(:,6) = readmatrix('pa_stretch.xlsx','Sheet','3M','Range','K2:K10');

% delta cap
C_vs_freq(:,1) = readmatrix('pa_stretch.xlsx','Sheet','10k','Range','D2:D10');
C_vs_freq(:,2) = readmatrix('pa_stretch.xlsx','Sheet','400k','Range','D2:D10');
C_vs_freq(:,3) = readmatrix('pa_stretch.xlsx','Sheet','700k','Range','D2:D10');
C_vs_freq(:,4) = readmatrix('pa_stretch.xlsx','Sheet','1M','Range','D2:D10');
C_vs_freq(:,5) = readmatrix('pa_stretch.xlsx','Sheet','2M','Range','D2:D10');
C_vs_freq(:,6) = readmatrix('pa_stretch.xlsx','Sheet','3M','Range','D2:D10');

% plot belt measured respiration data
subplot(2,1,1);
boxplot(F_vs_freq,freq/1e6, 'Whisker', 1)
% title('Change in capacitance due to skin stretch')
xlabel({'Corresponding capacitive sensor working frequency (MHz)', '(a)'});
ylabel('\DeltaF(N)');
grid on;
grid minor;

% plot delta C measured respiration data
subplot(2,1,2);
boxplot(C_vs_freq, 'Positions', log10(freq), 'Whisker', 1);
% title('Corresponding respiration belt data');
xlabel({'Frequency (Hz)', '(b)'});
ylabel('\DeltaC (pF)');
xlim([log10(1e3),log10(1e7)]);
% ylim([0 1]);
% Set x-axis ticks to log10(1e5), log10(1e6), and log10(1e7)
xticks(log10([1e3 1e4, 1e5, 1e6, 1e7]));
% Set x-axis tick labels
xticklabels({'1e3', '1e4', '1e5', '1e6', '1e7'});
grid on;
grid minor;

hold on;
plot(log10(freq), median(C_vs_freq), '--o',	'Color', 'k');

% Adjust the size of fig_scaled_C
fig_cha3_stretch.Units = 'centimeters';
fig_cha3_stretch.Position = [1, 1, 15, 15]; % Adjust these values based on your preference

% Save fig_scaled_C as an image (e.g., PNG)
print(fig_cha3_stretch, 'fig_cha3_freq_stretch', '-dpng', '-r300');