%%
fig_cha3_simulation = figure;
% freq = [0.01e6 0.4e6 0.7e6 1e6 2e6 3e6];
freq1 = [0.01e6 0.4e6 0.7e6 1e6 2e6 3e6 10e6 20e6];
% freq2 = [0.01e6 0.4e6 0.7e6 1e6 2e6];

% delta cap
C_vs_freq = readmatrix('Comsol_cap_result.xlsx','Sheet','Sheet1','Range','D2:D9');

% subplot(2,1,1);
plot(log10(freq1), C_vs_freq, '--o',	'Color', 'k');
% title('Corresponding respiration belt data');
xlabel('Frequency (Hz)');
ylabel('\DeltaC (pF)');
xlim([log10(1e3),log10(1e8)]);
% ylim([0 1]);
% Set x-axis ticks to log10(1e5), log10(1e6), and log10(1e7)
xticks(log10([1e3 1e4, 1e5, 1e6, 1e7, 1e8]));
% Set x-axis tick labels
xticklabels({'1e3', '1e4', '1e5', '1e6', '1e7', '1e8'});
grid on;
grid minor;

% subplot(2,1,2);
% plot(log10(freq1), C_vs_freq, '--o',	'Color', 'k');
% % title('Corresponding respiration belt data');
% xlabel('Frequency (Hz)');
% ylabel('\DeltaC (pF)');
% xlim([log10(1e3),log10(1e7)]);
% xticks(log10([1e3 1e4, 1e5, 1e6, 1e7]));
% % Set x-axis tick labels
% xticklabels({'1e3', '1e4', '1e5', '1e6', '1e7'});
% grid on;
% grid minor;




% Adjust the size of fig_scaled_C
fig_cha3_simulation.Units = 'centimeters';
fig_cha3_simulation.Position = [1, 1, 15, 10]; % Adjust these values based on your preference

% Save fig_scaled_C as an image (e.g., PNG)
print(fig_cha3_simulation, 'fig_cha3_freq_simulation', '-dpng', '-r300');