## README.md

# Pressure Sensitive Mat Optimisations

### Description
These Python Scripts were ran using Python 3.12.
The required modules and their exact versions can be found in "requirements.txt"

Each script can be ran on its own. The scripts require the "InputData" folder, as well as the "pressure_map.csv" file within it.
The scripts also require an "OutputData" folder to output data.

"GenerateAnOptimalGeometry.py" demonstrates how optimal geometries can be computed using our algorithms.
"OptimalGeometryComputations.py" computes the base errors for a default geometry, as well as the errors for an optimal geometry used in our paper. This script then saves the data as csv files within the "OutputData" folder.
"FootprintFittingComputations.py" implements the footprint fitting algorithm, saving the data as csv files within the "OutputData" folder.

## Dependencies
This project uses the following open-source libraries:
- **NumPy** (BSD 3-Clause License) - [https://numpy.org/](https://numpy.org/)
- **SciPy** (BSD 3-Clause License) - [https://scipy.org/](https://scipy.org/)
- **Matplotlib** (Matplotlib License) - [https://matplotlib.org/](https://matplotlib.org/)

## License
This project is licensed under the **Creative Commons Attribution 4.0 International (CC BY 4.0) License**. You are free to share and adapt this work, provided you give appropriate credit.

Full license text: [LICENSE](LICENSE)

## Disclaimer
This script is provided "as is" without any warranty of any kind, either express or implied, including but not limited to the warranties of merchantability, fitness for a particular purpose, and noninfringement. 
In no event shall the authors or copyright holders be liable for any claim, damages, or other liability, whether in an action of contract, tort, or otherwise, arising from, out of, or in connection with the software or the use or other dealings in the software.

Use at your own risk.
