
import matplotlib.pyplot as plt
import matplotlib as mpl

fig = plt.figure()
ax = fig.add_axes([0.05, 0.80, 0.9, 0.03])

cb = mpl.colorbar.ColorbarBase(ax, orientation='horizontal',
                               cmap='RdYlBu',
                               norm=mpl.colors.Normalize(-4, 4),  # vmax and vmin
                               extend='both',
                               ticks=[-3.6, 0 , 3.6])

cb.set_ticklabels(["4 kB Tension", "Equilbrium", "4 kB Compression"], fontsize=10)
plt.savefig(f"figures_hq/colorbar.png", bbox_inches='tight')

