import numpy as np
from matplotlib import pyplot as plt

colors = ["red", "orange", "green", "blue", "purple"]
legendFig = plt.figure("Legend plot")

x = np.linspace(1, 100, 1000) # Dummy Data
y = np.log(x) # Dummy Data

fig = plt.figure("Line plot")
legendFig = plt.figure("Legend plot")
ax = fig.add_subplot(111)

line1, = ax.plot(x, y, c="red", lw=2)
line2, = ax.plot(x, y, c="orange", lw=2)
line3, = ax.plot(x, y, c="green", lw=2)
line4, = ax.plot(x, y, c="blue", lw=2)
line5, = ax.plot(x, y, c="purple", lw=2)

# All 1 line mode
#legendFig.legend([line1, line2, line3, line4, line5], ["A: Undefected structure",
#                                                      "B: $\mathrm{T_{d}}$ Li in vacancy chain",
#                                                       "C: $\mathrm{O_{h}}$ Li in vacancy chain",
#                                                       "D: $\mathrm{O_{h}}$ and $\mathrm{T_{d}}$ Li in vacancy chain",
#                                                       "E: Dumbbell structure"], loc='center', ncol=3, fontsize=16)

labels_1 = ["A: Undefected structure", "B: $\mathrm{T_{d}}$ Li in vacancy chain", "C: $\mathrm{O_{h}}$ Li in vacancy chain"]
labels_2 = ["D: $\mathrm{O_{h}}$ and $\mathrm{T_{d}}$ Li in vacancy chain", "E: Dumbbell structure"]

legendFig.legend([line1, line2, line3], labels_1, loc='center', ncol=3, fontsize=16, frameon=False, bbox_to_anchor=(0.5,0.5))
legendFig.legend([line4, line5], labels_2, loc='center', ncol=2, fontsize=16, frameon=False, bbox_to_anchor=(0.5, 0.42))
plt.savefig(f"figures_hq/legend", bbox_inches='tight', dpi=600)


