import os

from pymatgen.core import Structure, Composition, Molecule
from pymatgen.io.vasp.sets import MPRelaxSet
from pymatgen.io.vasp.inputs import Poscar

"""Generation of images "A B C D E" should be sequential therefore there is no decent way of making these in bulk

# Current best scheme i could come up with involved a weird cascading pattern
1. Generation of A structures supercells [calculated from the min_cells] at their respective PSTRESS
2. Generation of subsequent step in transformation (B with a low resolution in the PSTRESS dimension 
    PSTRESS =  [-40, 0, +40 kB rather than every range(-40,40,2)) # PSTRESS outside of 40 seemed to have some issues

3. Halving the PSTRESS resolution and#merging  the lattice parameters (Since ISIF = 2) for the relevant 
 missing PSTRESS with its nearest calculated PSTRESS ion-coords

4. Repeat until delPSTRESS = 2 kB

 Since structures have to be passed from A -> B -> C -> D -> E this allows calculations o
 f the neb dimension to be ran in situ utilising the same schema

"""

# While energies could be in theory scaled up for structure A this in practice is not a great idea...
# Not much changes from min_cells_make other than EDIFF and EDIFFG (Deemed to be within tolerance...)
base_incar_settings={"ALGO": "Normal", "ISMEAR": 0, "SIGMA": 0.05, "LREAL": False,
                "PREC": "Accurate", "NCORE": 4, "EDIFF": 1E-04, "EDIFFG": -0.1, "PSTRESS": 0}

# Handle supercells
for metal_folder in ["cobalt_half_lithiation", "manganese_half_lithiation", "nickel_half_lithiation"]:
    os.makedirs(f"data/max_cells_response/{metal_folder}/A", exist_ok=True)  # Make A directory

    for pstress in range(-50, 50, 2):
        # Handle negatives in the dumbest way
        if pstress < 0:
            pstress_string = f"A_{abs(pstress)}"
        else:
            pstress_string = f"A{pstress}"

        # Load relevant structure and make A_supercell.
        structure = Structure.from_file(f"data/min_cells_response/{metal_folder}/{pstress_string}/CONTCAR")
        structure.make_supercell(scaling_matrix=[3, 3, 2]) # As per Seymour Grey et al. 126 atoms is a lot.

        incar = MPRelaxSet(structure=structure, user_incar_settings=base_incar_settings).incar

        if metal_folder == "cobalt_half_lithiation": # Dirty hack to fix magmoms
            mm = 18 * [0.0] + 18 * [0.0] + 18 * [1.0] + 72 * [0.05]
        elif metal_folder == "manganese_half_lithation":
            mm = 18 * [0.0] + 36 * [0.5] + 72 * [0.05]
        elif metal_folder == "nickel_half_lithiation":
            mm = 18 * [0.0] + 18 * [1.0] + 18 * [0.0] + 72 * [0.05]

        incar["MAGMOM"] = mm
        incar["PSTRESS"] = pstress

        f"data/min_cells_response/{metal_folder}/{pstress_string}/CONTCAR"

        os.makedirs(f"data/max_cells_response/{metal_folder}/A/{pstress_string}/", exist_ok=True)
        incar.write_file(filename=f"data/max_cells_response/{metal_folder}/A/{pstress_string}/INCAR")
        structure.to(filename=f"data/max_cells_response/{metal_folder}/A/{pstress_string}/POSCAR", fmt="poscar")
        structure.to(filename=f"data/max_cells_response/{metal_folder}/A/{pstress_string}/orig.vasp", fmt="poscar")

