import json
import os

from pymatgen.entries.computed_entries import ComputedStructureEntry
from pymatgen.io.vasp.outputs import Vasprun

""" 
Quick call to conver the heavy and large vapsrun.xml to a pymatgen CSE dict.
Should be noted this will print out errors mostly due to pymatgens handling of entropy adjustments but the final energy 
will be corect at a given PSTRESS (there will also be a corrected energy which attempts to recalculate the energy at 0 PSTRESS)
This is not desired for plotting purposes. 
"""

for root, dirs, files in os.walk(f"data/"):
    for file in files:
        if file.endswith(".xml"):

            try:
                file_dir = os.path.join(root, file)
                res_dir = root + "/results.json"
                vr = Vasprun(file_dir)

                c = vr.get_computed_entry(inc_structure=True)

                d = c.as_dict()
                with open(res_dir, "w") as f:
                    json.dump(d, f)

            except Exception as e:
                print(f"{file_dir} FAILED TO OPEN AS VASPRUN: {e}")

