import os

from pymatgen.core import Structure, Composition, Molecule
from pymatgen.io.vasp.sets import MPRelaxSet
from pymatgen.io.vasp.inputs import Poscar



#Custom vasp input settings since pymatgen is a little old and meh
# ALGO      = Normal        ! Fast algo gives +10% perf at some matrix inverse failing risks
# ISMEAR    = 0             ! unknown bandstructure
# SIGMA     = 0.05          ! small sigma yields better smearing
# LREAL     = False         ! LREAL = Auto/True is really only needed for large cells
# PREC      = "Accurate"    ! PREC : Accurate (Normal has been determined to be meh for these systems)
# NCORE     = 4             ! For better parr
# EDIFF     = 4E-06         ! Should be sufficent for near high-throughput + this size system size
# LWAVE     = True/False          ! Sick of keeping this flag true for high-throughput but its not an issue for min cases
# EDIFFG    = -0.010        ! Force convergence is important so will make this small ish
# PSTRESS   = $var          ! This will be changed through the calculations to test response

base_incar_settings={"ALGO": "Normal", "ISMEAR": 0, "SIGMA": 0.05, "LREAL": False,
                "PREC": "Accurate", "NCORE": 4, "EDIFF": 4E-06, "EDIFFG": -0.01, "PSTRESS": 0}

init_structure_file = "structures/min_cell_c2m.vasp" # [Taken as per Seymour, Grey et al]
init_structure = Structure.from_file(filename=init_structure_file)

# Convert from LiMn2O4 to LiX2O4 where X is Cobalt, Nickel and what ever other systems.
structure = init_structure
for metal in ["Co", "Mn", "Ni"]:
    if metal == "Co":
        st = "cobalt"
    elif metal == "Mn":
        st = "manganese"
    elif metal == "Ni":
        st = "nickel"
    else:
        st = None

    structure[1] = metal  # Assignment is simple since the structure is consistant
    structure[2] = metal

    # Take new structure and make Vasp inputs
    incar = MPRelaxSet(structure=structure, user_incar_settings=base_incar_settings).incar

    if metal == "Co": # Dirty hack to fix magmoms
        mm = 1 * [0.0] + 2 * [1.0] + 4 * [0.05]
    elif metal == "Mn":
        mm = 1 * [0.0] + 2 * [4.0] + 4 * [0.05]
    elif metal == "Ni":
        mm = 1 * [0.0] + 2 * [1.0] + 4 * [0.05]

    incar["MAGMOM"] = mm
    folder_string = f"data/min_cells_response/{st}_half_lithiation/"
    incar.write_file(filename=f"{folder_string}/INCAR_base") # make a base incar
    structure.to(filename=f"{folder_string}/initial_poscar.vasp", fmt="poscar") # base poscar

    for pstress in range(-50,52,2):
        # Handle negatives in the dumbest way
        if pstress < 0:
            pstress_string = f"A_{abs(pstress)}"
        else:
            pstress_string = f"A{pstress}"

        incar["PSTRESS"] = pstress
        os.makedirs(f"{folder_string}/{pstress_string}", exist_ok=True)
        incar.write_file(filename=f"{folder_string}/{pstress_string}/INCAR")
