import os
import shutil

from pymatgen.core import Structure, Composition, Molecule
from pymatgen.io.vasp.sets import MPRelaxSet
from pymatgen.io.vasp.inputs import Poscar

"""

Pretty simple inputting guesses for migrations that are to be used later on in the staggered calculations
The code is dumb and without a doubt not very user friendly 
but will work aslong as the CHANGEME VARIABLE is inputted correctly.

"""


def move_ion_structure(structure, ion, position):
    structure_new = structure
    structure_new[ion].frac_coords = position
    return structure_new

rough_moves = [[9,[0.610,0.666,0.770]], [9, [0.655,0.810,0.7550]], [4,[0.275, 0.666, 0.277]], [29,[0.379, 0.66, 0.690]]]

# First pass here. this code is used only once for each step across transition
stepsize = 40 #
STEP_VARIABLE = "CHANGEME"

for metal_folder in ["cobalt_half_lithiation", "manganese_half_lithiation", "nickel_half_lithiation"]:
    for pstress in range(-40, 40, stepsize):
        if pstress < 0:
            pstress_string = f"{STEP_VARIABLE}_{abs(pstress)}"
        else:
            pstress_string = f"{STEP_VARIABLE}{pstress}"
        # get structure n -> Make structure n+1
        folder = f"data/max_cells_response/{metal_folder}/{STEP_VARIABLE}/{pstress_string}"
        structure = Structure.from_file(filename=f"{folder}/CONTCAR")

        if STEP_VARIABLE == "A":
            NEXT_STEP = "B"
            ion_list = rough_moves[0]
            s = move_ion_structure(structure=structure, ion=ion_list[0], position=ion_list[1])

        elif STEP_VARIABLE == "B":
            NEXT_STEP = "C"
            ion_list = rough_moves[1]
            s = move_ion_structure(structure=structure, ion=ion_list[0], position=ion_list[1])

        elif STEP_VARIABLE == "C":
            NEXT_STEP = "D"
            ion_list = rough_moves[2]
            s = move_ion_structure(structure=structure, ion=ion_list[0], position=ion_list[1])

        elif STEP_VARIABLE == "D":
            NEXT_STEP = "E"
            ion_list = rough_moves[1]
            s = move_ion_structure(structure=structure, ion=ion_list[0], position=ion_list[1])

        pstress_new = NEXT_STEP + pstress_string[1:]
        new_folder = f"data/max_cells_response/{metal_folder}/{NEXT_STEP}/{pstress_string}/"
        os.makedirs(name=f"data/max_cells_response/{metal_folder}/{NEXT_STEP}", exist_ok=True)
        os.makedirs(name=f"{new_folder}/", exist_ok=True)

        s.to(filename=f"{new_folder}/orig.vasp", fmt="poscar")
        s.to(filename=f"{new_folder}/POSCAR", fmt="poscar")
        shutil.copy2(src=f"{folder}/INCAR", dst=f"{new_folder}/INCAR")




