import os

from pymatgen.core import Structure, Composition, Molecule
from pymatgen.io.vasp.sets import MPRelaxSet
from pymatgen.io.vasp.inputs import Poscar, Incar
from pymatgen.transformations.advanced_transformations import EnumerateStructureTransformation
from pymatgen.transformations.standard_transformations import SubstitutionTransformation, RemoveSpeciesTransformation



base_incar_settings={"ALGO": "Normal", "ISMEAR": 0, "SIGMA": 0.05, "LREAL": False,
                     "PREC": "Accurate", "NCORE": 4, "EDIFF": 1E-07, "EDIFFG": -0.005, "IVDW":0}

folder_names = ["quarter", "third", "half", "twothird", "threequarter"]
concs = [0.25, 1/3, 0.5, 2/3, 0.75]

swap = RemoveSpeciesTransformation(["Na"])
swapback = t = RemoveSpeciesTransformation(["Li"])

for metal in ["cobalt", "manganese", "nickel"]:
    if metal == "manganese":
        spin = 3.5
    else:
        spin = 0.5
    for sg in ["fd", "o2", "o3", "p2"]:
        for method in ["noU", "no_IVDW", "VDW_1", "VDW_2"]:
            structure = Structure.from_file(filename=f"{metal}/{sg}/full_lithiation/{method}/CONTCAR")
            for n,folder in enumerate(folder_names):
                f_ = f"{metal}/{sg}/{folder}_lithiation/{method}"
                os.makedirs(f"{metal}/{sg}/{folder}_lithiation/{method}", exist_ok=True)
                s2 = structure # copy structure
                d = {"Li": {"Li": concs[n], "Na": 1 - concs[n]}}
                transformation_method = SubstitutionTransformation(d)
                new_structure = transformation_method.apply_transformation(structure=structure)
                mix_transformation = EnumerateStructureTransformation(sort_criteria="nsites", min_cell_size=1, max_cell_size=4)
                result_list = mix_transformation.apply_transformation(new_structure, return_ranked_list=10)
                for n, i in enumerate(result_list):
                    os.makedirs(f"{f_}/{n}", exist_ok=True)
                    s_ = swap.apply_transformation(i["structure"])
                    s_.to(filename=f"{f_}/{n}/initial_poscar.vasp", fmt="poscar")
                    s_.to(filename=f"{f_}/{n}/POSCAR", fmt="poscar")
                    incar = MPRelaxSet(structure=structure, user_incar_settings=base_incar_settings).incar
                    lis = len([site for site in s_ if site.specie.symbol == "Li"])
                    cos = len([site for site in s_ if site.specie.symbol == "Co"])
                    cos += len([site for site in s_ if site.specie.symbol == "Mn"])
                    cos += len([site for site in s_ if site.specie.symbol == "Ni"])
                    o_s = len([site for site in s_ if site.specie.symbol == "O"])
                    mm = lis * [0.0] + cos * [spin] + o_s * [0.05]
                    incar["MAGMOM"] = mm
                    if method == "noU":
                        incar["LDAU"] = False
                    if method == "no_IVDW":
                        incar["IVDW"] = 0
                    if method == "VDW_1":
                        incar["IVDW"] = 1
                    if method == "VDW_2":
                        incar["IVDW"] = 11
                    incar.write_file(filename=f"{f_}/{n}/INCAR")





