import os

from pymatgen.core import Structure, Composition, Molecule
from pymatgen.io.vasp.sets import MPRelaxSet
from pymatgen.io.vasp.inputs import Poscar, Incar

#Custom vasp input settings since pymatgen is a little old and meh
# ALGO      = Normal        ! Fast algo gives +10% perf at some matrix inverse failing risks
# ISMEAR    = 0             ! unknown bandstructure
# SIGMA     = 0.05          ! small sigma yields better smearing
# LREAL     = False         ! LREAL = Auto/True is really only needed for large cells
# PREC      = "Accurate"    ! PREC : Accurate (Normal has been determined to be meh for these systems)
# NCORE     = 4             ! For better parr
# EDIFF     = 4E-06         ! Should be sufficent for near high-throughput + this size system size
# LWAVE     = True/False          ! Sick of keeping this flag true for high-throughput but its not an issue for min cases
# EDIFFG    = -0.010        ! Force convergence is important so will make this small ish

base_incar_settings={"ALGO": "Normal", "ISMEAR": 0, "SIGMA": 0.05, "LREAL": False,
                     "PREC": "Accurate", "NCORE": 4, "EDIFF": 1E-07, "EDIFFG": -0.005, "IVDW":0}

for metal in ["cobalt", "manganese", "nickel"]:
    for sg in ["fd", "o2", "o3", "p2"]:
        os.makedirs(f"data/{metal}/{sg}/no_lithiation/", exist_ok=True)
        for method in ["noU", "no_IVDW", "VDW_1", "VDW_2"]:
            os.makedirs(f"data/{metal}/{sg}/no_lithiation/{method}", exist_ok=True)
            structure = Structure.from_file(filename=f"data/{metal}/{sg}/full_lithiation/{method}/CONTCAR")
            l_ = len(structure)

            new_sites_spe = [s.species for s in structure if s.species_string != "Li"] # remove all Li
            new_sites_coords = [s.frac_coords for s in structure if s.species_string != "Li"]
            new_structure = Structure(structure.lattice, new_sites_spe, new_sites_coords)

            i = Incar.from_file(filename=f"data/{metal}/{sg}/full_lithiation/{method}/INCAR")
            i["LDAUL"] = i["LDAUL"][1:]
            i["LDAUU"] = i["LDAUU"][1:]
            i["LDAUJ"] = i["LDAUJ"][1:]
            i["MAGMOM"] = i["MAGMOM"][int(l_/4):]

            i.write_file(filename=f"data/{metal}/{sg}/no_lithiation/{method}/INCAR")
            new_structure.to(filename=f"data/{metal}/{sg}/no_lithiation/{method}/initial_poscar.vasp", fmt="poscar")
            new_structure.to(filename=f"data/{metal}/{sg}/no_lithiation/{method}/POSCAR", fmt="poscar")
