global FREE
global FIXED
global STORED
global Ntrials28
global Ntrials19
global Plot_Sims
global DensStartSub

%%%% these bits added to do noisy (log) density ratio
global Nsim
global norm28 %% for noise in density ratio
global norm28_2 %% for motor noise for trials28
global like28 % will be altered within fitting loop, but storage pre-declared
global Pos_vals
global Pos_edges
global Pos_incr

Pos_edges = linspace(0, 32, 101); %    0:0.32:32;
Pos_vals = 0.5*(Pos_edges(1:end-1)+Pos_edges(2:end));
Pos_incr = Pos_vals(2)-Pos_vals(1);

Ntrials28 = 35;
Ntrials19 = 10;
Plot_Sims = 2; % Number of iterations of fitting loop that make plots
FREE = 1; FIXED=0; STORED = 2;
Nsim = 20000;  % for simulated data, to derive likelihoods
norm28 = randn(Ntrials28, Nsim);
norm28_2 = randn(Ntrials28, Nsim);
like28 = zeros(size(norm28));
Plot_Sims = 0; % Number of iterations of fitting loop that make plots

%%% information about physical objects
MetalLength = 0:4:32;
PlasticLength = 32 - MetalLength;
nOb = 9;
TrueRatio = 3;

%%% calculate centre of mass, assuming object and metal part starts at x=0
for(ii=1:nOb)
    %%% Calculate pos and mass of two parts
    MetalPos(ii) = (MetalLength(ii)/2);
    PlasticPos(ii) =  MetalLength(ii) + (PlasticLength(ii)/2);
    MetalMass(ii) = MetalLength(ii)*TrueRatio;
    PlasticMass(ii) = PlasticLength(ii);
    %%% use these to get center of mass
    TrueCoM(ii) = (MetalPos(ii)*MetalMass(ii) + PlasticPos(ii)*PlasticMass(ii))/(MetalMass(ii) + PlasticMass(ii));
    k(ii) = TrueRatio; l(ii) = MetalLength(ii)/PlasticLength(ii);
    CheckCoM(ii) = (MetalPos(ii)*l(ii)*k(ii)+PlasticPos(ii))/(l(ii)*k(ii)+1);
end

%%%% for reversed objects (2b & 3a)
for(ii=1:nOb)
    %%% pretend just flipped - else mass estimate range will be screwed up
    MetalMass_R(ii) = MetalLength(ii);
    PlasticMass_R(ii) = PlasticLength(ii)*TrueRatio;
    %%% use these to get center of mass
    TrueCoM_R(ii) = (MetalPos(ii)*MetalMass_R(ii) + PlasticPos(ii)*PlasticMass_R(ii))/(MetalMass_R(ii) + PlasticMass_R(ii));
end

ObsI.Metal_Len = MetalLength;
ObsI.Metal_Pos = MetalPos;
ObsI.MetalMass = MetalMass;
ObsI.Plas_Pos = PlasticPos;
ObsI.Plas_Mass = PlasticMass;
ObsI.TrueCoM = TrueCoM;
ObsI.MetalMass_R = MetalMass_R;
ObsI.Plas_Mass_R = PlasticMass_R;
ObsI.TrueCoM_R = TrueCoM_R;

