function [MODEL] = model_setup(ModelType)

global FREE
global FIXED
global STORED

if(ModelType==1) % 3 params
    MODEL.LSpace = 1; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 4];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==2) % 4 params - with density noise
    MODEL.LSpace = 1; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FREE 4];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
     %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 4];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==3) % 3 params
    MODEL.LSpace = 2; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
     %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 4];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==4) % 4 params - with density noise
    MODEL.LSpace = 2; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FREE 4];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
     %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 4];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
%%% variations on fit both models - free start point for B
%%% and / or separate learning rates
elseif(ModelType==5) % ratio noise, no motor noise
    MODEL.LSpace = 1; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 4];
    MODEL.LearnRate_B = [FREE 5]; %
elseif(ModelType==6) % ratio noise, no motor noise
    MODEL.LSpace = 2; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 4];
    MODEL.LearnRate_B = [FREE 5]; % same as A
elseif(ModelType==7) % As model 1, but with free density start point for A
    MODEL.LSpace = 1; % density (1) or log density (2)
    MODEL.DensStart = [FREE 1]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 2]; % second val gives the parameter index
    MODEL.LRate = [FREE 3];
    MODEL.MotSigma = [FREE 4]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FREE 5]; % no carry over
    MODEL.DensEnd_B = [FREE 6];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==8) % % As model 3, but with free density start point
    MODEL.LSpace = 2; % density (1) or log density (2)
    MODEL.DensStart = [FREE 1]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 2]; % second val gives the parameter index
    MODEL.LRate = [FREE 3];
    MODEL.MotSigma = [FREE 4]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FREE 5]; % carry over
    MODEL.DensEnd_B = [FREE 6];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==9) % ratio noise, no motor noise
    MODEL.LSpace = 1; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 2]; % second val gives the parameter index
    MODEL.LRate = [FREE 3];
    MODEL.MotSigma = [FREE 4]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FREE 5]; % carry over
    MODEL.DensEnd_B = [FREE 6];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==10) % ratio noise, no motor noise
    MODEL.LSpace = 2; % density (1) or log density (2)
    MODEL.DensStart = [FREE 1]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 2]; % second val gives the parameter index
    MODEL.LRate = [FREE 3];
    MODEL.MotSigma = [FREE 4]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FREE 5]; % carry over
    MODEL.DensEnd_B = [FREE 6];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==11) % as 1, but with all sep params for B, except startB
    MODEL.LSpace = 1; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 2]; % second val gives the parameter index
    MODEL.LRate = [FREE 3];
    MODEL.MotSigma = [FREE 4]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FREE 5]; % carry over
    MODEL.DensEnd_B = [FREE 6];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==12) % as 3, but with all sep params for B, except startB
    MODEL.LSpace = 2; % density (1) or log density (2)
    MODEL.DensStart = [FREE 1]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 2]; % second val gives the parameter index
    MODEL.LRate = [FREE 3];
    MODEL.MotSigma = [FREE 4]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FREE 5]; % carry over
    MODEL.DensEnd_B = [FREE 6];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==13) % as (1) but with free orientation bias
    MODEL.LSpace = 1; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FREE 4];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 5];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==14) % as (3) but free orientation bias
    MODEL.LSpace = 2; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FREE 4];  %% change 2nd value to 0.321227 for alt model
     %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 5];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==15) % as (1) but with fixed orientation bias
    MODEL.LSpace = 1; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0.321227];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 5];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==16) % as (3) but fixed orientation bias
    MODEL.LSpace = 2; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0.321227];  %% change 2nd value to 0.321227 for alt model
     %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 5];
    MODEL.LearnRate_B = [FIXED NaN]; % same as A
elseif(ModelType==17) % as 1, but with ALL sep params for B, except startB
    MODEL.LSpace = 1; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 0]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 4];
    MODEL.MotSigma_B = [FREE 5];
    MODEL.LearnRate_B = [FREE 6]; 
elseif(ModelType==18) % as 3, but with ALL sep params for B, except startB
    MODEL.LSpace = 2; % density (1) or log density (2)
    MODEL.DensStart = [FIXED 1]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% only used if FIT_BOTH=1;
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 4];    
    MODEL.MotSigma_B = [FREE 5];
    MODEL.LearnRate_B = [FREE 6]; 
elseif(ModelType==19) % using indep fit end density from part A
    MODEL.LSpace = 1; % density (1) or log density (2)
    MODEL.DensStart = [STORED NaN]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% model never used to fit both
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 4];
    MODEL.MotSigma_B = [FREE 5];
    MODEL.LearnRate_B = [FREE 6]; 
elseif(ModelType==20) % % using indep fit end density from part A
    MODEL.LSpace = 2; % density (1) or log density (2)
    MODEL.DensStart = [STORED NaN]; % second val is what it is fixed as
    MODEL.DensEnd = [FREE 1]; % second val gives the parameter index
    MODEL.LRate = [FREE 2];
    MODEL.MotSigma = [FREE 3]; % sigma of response noise, obs 1-9
    MODEL.RatSigma = [FIXED 0];
    MODEL.OrB=[FIXED 0];  %% change 2nd value to 0.321227 for alt model
    %%% model never used to fit both
    MODEL.DensStart_B = [FIXED NaN]; % carry over
    MODEL.DensEnd_B = [FREE 4];    
    MODEL.MotSigma_B = [FREE 5];
    MODEL.LearnRate_B = [FREE 6];
end