function [ParSet] = setParams(free_params, MODEL, sub_dat19, Part)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here
global FREE
global STORED
%%%% start point exponential
if(MODEL.DensStart(1) == FREE)
    ParSet.DensStart = free_params(MODEL.DensStart(2));

else

    if(MODEL.LSpace==1) % regular
        ParSet.DensStart = 1;
    else % log space
        ParSet.DensStart = 0;
    end
end

if(MODEL.DensEnd(1) == FREE)
    ParSet.DensEnd = free_params(MODEL.DensEnd(2));
else
    ParSet.DensEnd = DensStart; % doesn't really make sense
end
if(MODEL.LRate(1) == FREE)
    ParSet.LearnRate = free_params(MODEL.LRate(2));
end

%%% grasping noise
if(MODEL.MotSigma(1) == FREE)
    ParSet.MotSigma = free_params(MODEL.MotSigma(2));
else
    ParSet.MotSigma = MODEL.MotSigma(2);
    %%% or take from data
    ParSet.MotSigma = std(sub_dat19(:, 2), 0,'all');
end
if(MODEL.RatSigma(2)==FREE)
    ParSet.RatSigma = free_params(MODEL.RatSigma(2));
else
    ParSet.RatSigma = 0;
end
%%% orientation bias
if(MODEL.OrB(1)==FREE)
    ParSet.OrBias = free_params(MODEL.OrB(2));
else
    ParSet.OrBias = 0; % no orientation bias
    %%% or take mean from data
    %  OrBias = 0.4; % check sign
end

if(Part==2)
    %%% replace some parameters with those for part 2
    if(MODEL.DensStart_B(1) == FREE)
        ParSet.DensStart = free_params(MODEL.DensStart_B(2));
    else % end start point is fixed
        %%%% but need to be taken from DR fit to part A
        if(MODEL.LSpace==1) % regular
            ParSet.DensStart = NaN;
        else % log space
            ParSet.DensStart = NaN;
        end
    end
    if(MODEL.DensEnd_B(1) == FREE)
        ParSet.DensEnd = free_params(MODEL.DensEnd_B(2));
    else
        ParSet.DensEnd = NaN; 
    end
    %%% ratio std, motor std stay the same??
    if(MODEL.LearnRate_B(1) == FREE)
        ParSet.LearnRate = free_params(MODEL.LearnRate_B(2));
    else
        %%% leave same as set above from part A
        %%% do nothing
    end
    if(isfield(ParSet, 'MotSigma_B'))
        if(MODEL.MotSigma_B(1) == FREE)
            ParSet.MotSigma = free_params(MODEL.MotSigma_B(2));
        else
            %%%% same as part A motion sigma
            ParSet.MotSigma = free_params(MODEL.MotSigma(2));
        end
    end
end

end