%%%%% stats tests on fitted params
%%%%% only going to use models 1 / 3 for E1, 2A, 3A
%%%%% models 19/20 (or 21/22, when fitted) for E2B, E3B
clear all;
close all;
Define_Vars;

lightgrey = [0.9 0.9 0.9];
lightpink = [1 0.9 0.9];


%%% compare learning rates

REG = 0;
if(REG)
    %Model1 = 1; Model2 = 5;
    %Model1 = 1; Model2 = 17; % only carryover point connects A and B
    Model1 = 1; Model2 = 19; % carry-over but B ind fit?
else % log space
    %Model1 = 3; Model2 = 6;
    %Model1 = 3; Model2 = 18;
    Model1 = 3; Model2 = 20;
end
for(Expt_Num=[1 2 3])
    FIT_BOTH = 0;
    MODEL1 = model_setup(Model1);
    FileName1 = get_resultsFileName(Expt_Num, FIT_BOTH, MODEL1);
    load(FileName1, 'bestError', 'bestParams');
    DensStart1(Expt_Num, :) = zeros(1, 20);
    DensEnd1(Expt_Num, :) = bestParams(:, 1);
    LRate1(Expt_Num, :) = bestParams(:, 2);
end
%for(Expt_Num=[2 3])
for(Expt_Num=[2 3])  %%% now only using part B for these
    FIT_BOTH = 0;
    MODEL2 = model_setup(Model2);
 %   FileName1 = get_resultsFileName(Expt_Num, FIT_BOTH, MODEL2);
  FileName1 = get_resultsFileName(Expt_Num+0.5, FIT_BOTH, MODEL2);
    load(FileName1, 'bestError', 'bestParams');
    %%% part A %%%%
%    DensStart2(Expt_Num, :) = zeros(1, 20);
    if(MODEL2.DensStart(1)==STORED)
        %%% could load stored params, or use end from above
        %%%% AGGHHH Have to use correct model to get start points from
        %%% need to re-fit 19 & 20 (21 & 22) using models 1 & 3.
        DensStart2(Expt_Num, :) = DensEnd1(Expt_Num, :);
    end
  
    %%%% if carryover
    DensEnd2(Expt_Num, :) = bestParams(:, 1);
    LRate2(Expt_Num, :) = bestParams(:, 2);

    X = 0:Ntrials28-1; % assumes no learning on trials with objects 1 and 9
    for(ss=1:20)
   
        Est_D = (DensStart2(Expt_Num, ss) - DensEnd2(Expt_Num, ss)) * exp(-LRate2(Expt_Num, ss) * X) + DensEnd2(Expt_Num, ss);

    end
end

%%%%
%%%% organise data for box plot
Rate_Data = [LRate1(1:2, :)' LRate2(2, :)' LRate1(3, :)' LRate2(3, :)'];
fh = figure('Name', 'LRates and Extent');
subplot(1, 2, 1); hold on;
%%% add shaded region
X_loop = [2.5 2.5 3.5 3.5 2.5];
X_loop2 = [3.5 3.5 4.5 4.5 3.5];
Y_loop = [-0.5 5.5 5.5 -0.5 -0.5];
fill(X_loop, Y_loop, lightpink);
fill(X_loop2, Y_loop, lightpink);


boxplot(Rate_Data);

xlim([0.5 5.5]);
ylim([-0.45 5.45]);
xticks([1 2 3 4 5])
xticklabels({'1', '2A', '2B','3A', '3B'});
xlabel('Experiment');
ylabel('Learning Rate');

subplot(1, 2, 2); hold on;
LExtent = [(1/log(2.96))*DensEnd1(1:2, :)' (-1/log(3.004))*DensEnd2(2, :)' (-1/log(3.004))*DensEnd1(3, :)' (1/log(2.96))*DensEnd2(3, :)'];

%%% add shaded region
X_loop = [2.5 2.5 3.5 3.5 2.5];
X_loop2 = [3.5 3.5 4.5 4.5 3.5];
Y_loop = [-0.5 5.5 5.5 -0.5 -0.5];
fill(X_loop, Y_loop, lightpink);
fill(X_loop2, Y_loop, lightpink);

boxplot(LExtent);
yline(1, 'k--');

xlim([0.5 5.5]);
ylim([-0.45 3]);
xticks([1 2 3 4 5])
xticklabels({'1', '2A', '2B','3A', '3B'});
xlabel('Experiment');
ylabel('Learning Extent');

fontsize(fh, 16, "points");


%%% now in correct order
LRates = log(Rate_Data);
aovL = anova(LRates)
mL = multcompare(aovL)

aovE = anova(LExtent')
mE = multcompare(aovE)



%%% Expt 1
fprintf('Extent, Expt 1\n');
[H,P,CI,STATS] = ttest(DensEnd1(1, :), log(3))
%%% Expt 2a
fprintf('Extent, Expt 2a\n');
[H,P,CI,STATS] = ttest(DensEnd1(2, :), log(3))
%%% Expt 2b
fprintf('Extent, Expt 2b\n');
[H,P,CI,STATS] = ttest(DensEnd2(2, :), -log(3))
%%% Expt 3a
fprintf('Extent, Expt 3a\n');
[H,P,CI,STATS] = ttest(DensEnd1(3, :), -log(3))
%%% Expt 3b
fprintf('Extent, Expt 3b\n');
[H,P,CI,STATS] = ttest(DensEnd2(3, :), log(3))

