%%% WJA Nov 2024
%%% plot relationship between log density ratio and normalised grasp
%%% position for each object

close all;
clear all;

Define_Vars;

%%% Estimates of Log Density %%%
LogD = -1.8:0.1:1.8;
LinD = exp(LogD);

COND = 1; % normal rather than inverted (-1)

figure('Name', 'Grasp Metrics');
subplot(1, 3, 1); hold on;
xlabel('Log Density Ratio'); ylabel('Centre of Mass, cm');
subplot(1, 3, 2); hold on;
xlabel('Log Density Ratio'); ylabel('CoM, Normaliesd Location');
subplot(1, 3, 3); hold on;
xlabel('Log Density Ratio'); ylabel('CoM, Normaliesd Location');


for(ob=2:8)
    GraspPosns(ob, :)=dens2grasp2(LinD, ob, ObsI, 1);
    NormGrasp(ob, :) = grasp2norm2(squeeze(GraspPosns(ob, :)), ob, ObsI, COND);
    NormGraspR(ob, :) = grasp2norm2(squeeze(GraspPosns(ob, :)), ob, ObsI, -COND);

    subplot(1, 3, 1);
    plot(LogD, squeeze(GraspPosns(ob, :)), LineWidth=1.5);
    subplot(1, 3, 2);
    plot(LogD, squeeze(NormGrasp(ob, :)), LineWidth=1.5);
    subplot(1, 3, 3);
    plot(LogD, squeeze(NormGraspR(ob, :)), LineWidth=1.5);
end

for(subp = 1:3)
    subplot(1,3,subp);
    xline(0, 'r--', LineWidth=2);
    if(subp==1)
        yline(16, 'k--', LineWidth=2);
        xline(log(3), LineWidth=2, Color=[0.6 0.6 0], LineStyle="--");
        xline(log(1/3), 'g--', LineWidth=2);
        xlim([-1.5 1.5]);
    elseif(subp==2)
        xline(log(3), 'g--', LineWidth=2);
        yline(0, 'k--',  LineWidth=1.5); yline(1, 'k:',  LineWidth=1.5);
        %xlim([-1.5 1.5]);
        xlim([-0.5 log(3)+0.5]);
    elseif(subp==3)
        xline(log(1/3), 'g--', LineWidth=2);
        yline(0, 'k--',  LineWidth=1.5); yline(1, 'k:',  LineWidth=1.5);
        %xlim([-1.5 1.5]);
        xlim([log(1/3)-0.5 0.5]);
    end
    ax = gca;  ax.FontSize = 16;
    if(subp==3)
        legend({'ob2', 'ob3', 'ob4', 'ob5', 'ob6', 'ob7', 'ob8'});
    end
end
