%%% f ratio test to compare two models 

close all;
clear all;

SINGLE_VS_SEP = 0; %%% if doing together vs separate comparison

Define_Vars;


%%% Final model is 3 for Expt 1, 2A, 3A
%%% Final model is 20 for Expt 2B, 3B
%%% it does not do 'FIT_BOTH' as A and B are fit independently as models 3


%for (Expt_Num = [1 2 2.5 3 3.5])
%for (Expt_Num = [1 2 3])
 for (Expt_Num = [2.5 3.5]) % use this for fits for parts B

NSUBS = 20;

Model1 = 20; % more complex model / model for separate analyses
Model2 = 19; % simpler model / model for together analyses

FIT_BOTH = 0; % only relevant for simple comparison across models


if(SINGLE_VS_SEP==0)

%%% more complex model
MODEL1 = model_setup(Model1);
FileName1 = get_resultsFileName(Expt_Num, FIT_BOTH, MODEL1)
MODEL2 = model_setup(Model2);
FileName2 = get_resultsFileName(Expt_Num, FIT_BOTH, MODEL2)

% load more complex model
load(FileName1, 'bestError', 'bestParams', 'iterationParams', 'iterationError', 'repsDone');
bestParams1 = bestParams;
for(ii=1:size(bestParams, 2))
    fprintf('Model %d, Param %d, %f, %f\n', Model1, ii, mean(bestParams(:, ii)), std(bestParams(:, ii)))
end
fprintf('Model %d, Error %f, std %f\n', Model1, mean(bestError), std(bestError));
fprintf('\n');

uLogL = bestError;

dof1 = size(iterationParams, 3)*ones(1, NSUBS);

%%% load restricted model
load(FileName2, 'bestError', 'bestParams', 'iterationParams', 'iterationError', 'repsDone');
bestParams2 = bestParams;
for(ii=1:size(bestParams, 2))
    fprintf('Model %d, Param %d, %f, %f\n', Model2, ii, mean(bestParams(:, ii)), std(bestParams(:, ii)))
end
fprintf('Model %d, Error %f, std %f\n', Model2, mean(bestError), std(bestError));
fprintf('\n');

rLogL = bestError;
dof2 = size(iterationParams, 3)*ones(1, NSUBS);


%dof = ones(1, length(bestError));
dof = dof1 - dof2;

if(dof(1)==0)
    [-uLogL' -rLogL' (-rLogL<-uLogL)']
    fprintf('Expt %d first model bigger (better) likelihood for % d of %d subs\n', Expt_Num, sum(-rLogL<-uLogL), length(dof));
else
    [h,pValue,stat] = lratiotest(-uLogL,-rLogL,dof);
fprintf('Expt %d bigger (first) model better for %d of %d subs\n', Expt_Num, sum(pValue<0.05), length(dof));
[-uLogL' -rLogL' pValue']
end

elseif(SINGLE_VS_SEP)

%%% Quick comparison of analysis together vs separate for expts 2 & 3
%%% more complex model

MODEL1 = model_setup(Model1);

FileName{1} = get_resultsFileName(Expt_Num, 0, MODEL1)
FileName{2} = get_resultsFileName(Expt_Num+0.5, 0, MODEL1)

MODEL2 = model_setup(Model2);
FileName{3} = get_resultsFileName(Expt_Num, 1, MODEL2)

for(ff=1:3)
    load(FileName{ff}, 'bestError', 'bestParams', 'iterationError', 'iterationParams', 'repsDone');
    mean(bestParams)
    switch ff
        case 1, A = bestError; dofA = size(bestParams, 2)*ones(1, length(bestError));
        case 2, B = bestError; dofB = size(bestParams, 2)*ones(1, length(bestError));
        case 3, Both = bestError; dofBoth = size(bestParams, 2)*ones(1, length(bestError));
    end
end


[A' B' A'+B' Both']

dof = (dofA + dofB) - dofBoth;
uLogL = A+B; rLogL = Both;
[h,pValue,stat] = lratiotest(-uLogL,-rLogL,dof);
[-uLogL' -rLogL' pValue']

fprintf('bigger (first) model better for %d of %d subs\n', sum(pValue<0.05), length(dof));

end
end