%%%% for a model or models plot the fit and data, as normalised grasping
%%%% position
%%%% in version 2, the asymptotic values are calculated separately per
%%%% window, depending on the subs represented in the window
clear all;
%close all;

subs = 1:20; % sub numbers 1 to 20
Define_Vars;

lightgreen = [0.9 1 0.9];
lightgrey = [0.9 0.9 0.9];
lightpink = [1 0.9 0.9];

trial_window = 4; % aggregate across N trials
asymptote_from = 15; %% trial from where data get averaged for asymptote
window_list = [];
for(t_start=1:Ntrials28-(trial_window-1))
    window_list = [window_list; t_start:(t_start+trial_window-1)];
end
nWindows = size(window_list, 1);

Expt_List = [1 2 2.5 3 3.5];
for(ee=1:5)
    Expt_Num = Expt_List(ee);
    %%% load data and organise
    [DataA] = load_data(Expt_Num);
    subList = unique(DataA(:,1));

    for(ss = subs)
        [data19_A, data28_A] = getSubData(DataA, subList(subs(ss)));
        raw_data28(ss, 1:Ntrials28, 1:3) = [(1:Ntrials28)' data28_A]; % trial N, ob number, grasp position
    end

    %%% find representation of subs per object for each trial window %%%
    for(ww=1:nWindows)
        for(obN=2:8)
            for(ss=1:20)
                obIndex = find(raw_data28(ss, :, 2)==obN & ismember(raw_data28(ss, :, 1), window_list(ww, :))); % roughly 2nd half of trials
                SubRep(ww, obN, ss) = length(obIndex);
            end
        end
    end

    %%% find asymptotic grasping positions per object, weighted by subs,
    %%% for each window
    for(ww=1:nWindows)
    for(obN=2:8)
        %%% get list of relevant subs
        subsObWin = find(squeeze(SubRep(ww, obN, :))>0);
        obIndex = find(raw_data28(subsObWin, :, 2)==obN & raw_data28(subsObWin, :, 1)>=asymptote_from); % roughly 2nd half of trials
        tempdata = raw_data28(subsObWin, :, 3);
        tempdata2 = tempdata(obIndex);
        ObWinAsym(ww, obN, 1) = mean(tempdata2);
        ObWinAsym(ww, obN, 2) = std(tempdata2)/sqrt(length(tempdata2));
    end
    end

    %%% find mean grasp per object for each trial window %%%
    for(ww=1:nWindows)
        for(obN=2:8)
            obIndex = find(raw_data28(:, :, 2)==obN & ismember(raw_data28(:, :, 1), window_list(ww, :))); % roughly 2nd half of trials
            tempdata = raw_data28(:, :, 3);
            tempdata2 = tempdata(obIndex);
            ObWin(ww, obN, 1) = mean(tempdata2);
            ObWin(ww, obN, 2) = std(tempdata2)/sqrt(length(tempdata2));
        end
        %%% get correlation
       [WinCorr(ww, 1), WinCorr(ww, 2)]=corr(ObWin(ww, 2:8, 1)', ObWinAsym(ww, 2:8, 1)');
    end

    %%% find first time point where correlation is significant
    SigInd = find(WinCorr(:, 2)<0.05);
    FirstSig(ee) = min(SigInd);

    %%% plot the evolving grasp positions per object
    if(ee==1)
        figHEvo = figure('Name', 'evolutions, type 2');
    else
        figure(figHEvo);
    end
    switch ee
        case 1, subplot(2, 3, 1);title('Expt 1');
        case 2, subplot(2, 3, 2);title('Expt 2A');
        case 3, subplot(2, 3, 5);title('Expt 2B');
        case 4, subplot(2, 3, 3);title('Expt 3A');
        case 5, subplot(2, 3, 6);title('Expt 3B');
    end

    if(ee==1 || ee==2 || ee==5)
      yMin = 16 - 6.5; yMax = 16 + 1.5;
    else
      yMin = 16 - 1.5; yMax = 16 + 6.5;
    end
    hold on;
    %%%% add some indication of where divergence starts
    %%% add shaded region
   %%% pre-plot this so legend is easy
for(obN=2:8)
        %    errorbar(1:nWindows, ObWin(:, obN, 1), ObWin(:, obN, 2), '*-', LineWidth=1);
       plot(1:nWindows, ObWin(:, obN, 1), LineWidth=2);
end
yline(16, 'k--', LineWidth=2);

    for(ww=1:nWindows)
        if(WinCorr(ww, 2)<0.05)
           % barcount=barcount+1;
            xMin = ww-0.5; xMax = ww+0.5;
            X_loop = [xMin xMin xMax xMax xMin];
            Y_loop = [yMin yMax yMax yMin yMin];
            fill(X_loop, Y_loop, lightgreen,'LineStyle','none');
        end
    end
    for(obN=2:8)
        errorbar(1:nWindows, ObWin(:, obN, 1), ObWin(:, obN, 2), '*-', LineWidth=1);
        %    plot(1:nWindows, ObWin(:, obN, 1), LineWidth=2);
    end
    for(obN=2:8)
        %    errorbar(1:nWindows, ObWin(:, obN, 1), ObWin(:, obN, 2), '*-', LineWidth=1);
       linesH = plot(1:nWindows, ObWin(:, obN, 1), LineWidth=2);
    end
    ylim([yMin yMax])
    xlim([0 Ntrials28 - (trial_window-2)])
    yline(16, 'k--', LineWidth=2);
    xlabel('Trial Window');
    ylabel('Mean Grasping Position (cm)');
    fontsize(figHEvo, 16, "points");
    if(ee==1)
    legend({'object 2', 'object 3', 'object 4', 'object 5', 'object 6', 'object 7', 'object 8', 'GC'})
    end


end
