% Orientation effects, WJA,
% 2024 added in data from control expt (4)
% 2024 added option to exclude first N trials (where learning will add
% noise)


clear all; close all;

Define_Vars;
N_EXCLUDE = 0; % number of trials to exclude at start

fig1 = figure('name', 'Objects 2 through 8');
fig2 = figure('name', 'Objects 1 and 9');
sgtitle('Mean Grasp Value over Subjects')

legendString = [];
for ee=1:6
    switch ee
        case 1, Expt_Num = 1;
        case 2, Expt_Num = 2;
        case 3, Expt_Num = 2.5;
        case 4, Expt_Num = 3;
        case 5, Expt_Num = 3.5;
        case 6, Expt_Num = 4;
    end
    %Expt_Num = 3.5; % 1, 2, 2.5, 3, 3.5
    switch Expt_Num
        case 1, load('../Data/Data_Exp1.mat'); %%% read in observer data
        case 2, load('../Data/Data_Exp2a.mat');
        case 2.5, load('../Data/Data_Exp2b.mat');
        case 3, load('../Data/Data_Exp3a.mat');
        case 3.5, load('../Data/Data_Exp3b.mat');
        case 4, load('../Data/Data_Exp4.mat');
    end

    %%% a trial number column
    SubList = unique(Data(:, 1));
    NSUBS = length(SubList);
    TrialsPerSub = length(Data(:, 1))/NSUBS;
    TrialNumber = repmat(1:TrialsPerSub, 1, NSUBS);
    Data = [Data TrialNumber'];


    %     %Find the mean grasping position per object
    %%% separately per subject
    for(ss=1:NSUBS) %% not clear how ss is involved...
        for ob = 1:9
            %for ob = 2:8
            if ob==1 || ob==9
                tempIndex1 = find(Data(:,3)==ob & Data(:, 1)==SubList(ss));
                meanGrasp(ss, ob,1) = mean(Data(tempIndex1,5));
                stdGrasp(ss, ob,1) = std(Data(tempIndex1,5));
            else
                if(Expt_Num<4)
                    tempIndex = find(Data(:,3)==ob & Data(:,4)==0 & Data(:, 6)>N_EXCLUDE & Data(:, 1)==SubList(ss));
                    if(isempty(tempIndex))
                        fprintf('no data for Ee: %d, ss: %d, ob: %d, orient1\n', Expt_Num, ss, ob);
                    end
                    %tempIndex =
                    meanGrasp(ss, ob,1) = mean(Data(tempIndex,5));
                    stdGrasp(ss, ob,1) = std(Data(tempIndex,5));
                    tempIndex2 = find(Data(:,3)==ob & Data(:,4)==1  & Data(:, 6)>N_EXCLUDE & Data(:, 1)==SubList(ss));
                    if(isempty(tempIndex2))
                        fprintf('no data for Ee: %d, ss: %d, ob: %d, orient2\n', Expt_Num, ss, ob);
                    end
                    meanGrasp(ss, ob,2) = mean(Data(tempIndex2,5));
                    stdGrasp(ss, ob,2) = std(Data(tempIndex2,5));
                else % control expt with different hands & handedness
                    tempIndex = find(Data(:,3)==ob & Data(:,4)==0 & Data(:, 6)==1 & Data(:, 7)>N_EXCLUDE & Data(:, 1)==SubList(ss));  % right hand
                    meanGrasp4(ss, ob,1, 1) = mean(Data(tempIndex,5));
                    stdGrasp4(ss, ob,1, 1) = std(Data(tempIndex,5));
                    tempIndex2 = find(Data(:,3)==ob & Data(:,4)==1 & Data(:, 6)==1 & Data(:, 7)>N_EXCLUDE & Data(:, 1)==SubList(ss));  % right hand
                    meanGrasp4(ss, ob,2, 1) = mean(Data(tempIndex2,5));
                    stdGrasp4(ss, ob,2, 1) = std(Data(tempIndex2,5));

                    tempIndex = find(Data(:,3)==ob & Data(:,4)==0 & Data(:, 6)==2 & Data(:, 7)>N_EXCLUDE & Data(:, 1)==SubList(ss));  % left hand
                    meanGrasp4(ss, ob,1, 2) = mean(Data(tempIndex,5));
                    stdGrasp4(ss, ob,1, 2) = std(Data(tempIndex,5));
                    tempIndex2 = find(Data(:,3)==ob & Data(:,4)==1 & Data(:, 6)==2 & Data(:, 7)>N_EXCLUDE & Data(:, 1)==SubList(ss));  % left hand
                    meanGrasp4(ss, ob,2, 2) = mean(Data(tempIndex2,5));
                    stdGrasp4(ss, ob,2, 2) = std(Data(tempIndex2,5));
                end
            end
        end
        if(Expt_Num<4)
            AllGrasp(ss, ee, 1:7, 1) = meanGrasp(ss, 2:8,1);
            AllGrasp(ss, ee, 1:7, 2) = meanGrasp(ss, 2:8,2);

            bias28(ss, ee,1:7) = meanGrasp(ss, 2:8,1) - meanGrasp(ss, 2:8,2);
            bias19(ss, ee,1) = 2*(16 - (meanGrasp(ss, 1,1)));
            bias19(ss, ee,2) = 2*(16 - (meanGrasp(ss, 9,1)));
        else
            % control expt
            bias28_4(ss, [3 5 7], 1) = meanGrasp4(ss, [3 5 7],1, 1) - meanGrasp4(ss, [3 5 7],2, 1); % right hand
            bias28_4(ss, [3 5 7], 2) = meanGrasp4(ss, [3 5 7],1, 2) - meanGrasp4(ss, [3 5 7],2, 2); % left hand
        end
    end % end subs loop

    %%%% organise data
    if(ee<6)
    SubMeans(ee, :, :) = mean(meanGrasp, 1, 'omitnan');
    SubSE(ee, :, :) = std(meanGrasp, [], 1, 'omitnan')./sqrt(NSUBS);
    end

    if(ee==6)
    SubMeans4(:, :, :) = mean(meanGrasp4, 1, 'omitnan');
    SubSE4(:, :, :) = std(meanGrasp4, [], 1, 'omitnan')./sqrt(NSUBS);
    end


    set(0, 'CurrentFigure', fig1);
    s1 = subplot(2, 3, ee, 'Parent', fig1); hold on;
    if(Expt_Num<4)

        errorbar(s1,2:8, SubMeans(ee, 2:8,1)', SubSE(ee, 2:8,1)', 'b', 'LineWidth', 2);
        errorbar(s1,2:8, SubMeans(ee, 2:8,2)', SubSE(ee, 2:8,2)', 'r', 'LineWidth', 2);
    else
    
        OFFSET = 0.25;
         errorbar(s1,(3:2:7)+OFFSET,SubMeans4(3:2:7,1,1)', SubSE4(3:2:7,1,1)', 'bo-', 'LineWidth', 2);
        errorbar(s1,(3:2:7)+OFFSET,SubMeans4(3:2:7,2,1)', SubSE4(3:2:7,2,1)', 'r*-', 'LineWidth', 2);
        errorbar(s1,(3:2:7)-OFFSET,SubMeans4(3:2:7,1,2)', SubSE4(3:2:7,1,2)', 'bo--', 'LineWidth', 2);
        errorbar(s1,(3:2:7)-OFFSET,SubMeans4(3:2:7,2,2)', SubSE4(3:2:7,2,2)', 'r*--', 'LineWidth', 2);
    end

    %%% add true CoM
    if(ee==3 || ee==4)
        plot(2:8, ObsI.TrueCoM_R(2:8), 'k--o', 'LineWidth', 2);
    elseif(ee==1 || ee==2 || ee==5)
        plot(2:8, ObsI.TrueCoM(2:8), 'k--o', 'LineWidth', 2);
    else
        plot([3 5 7], ObsI.TrueCoM([3 5 7]), 'k--o', 'LineWidth', 2);
    end

    %%% for ee 1 - 5 add objects 1 & 9
    if(ee<6)
        errorbar(s1, [1 9], SubMeans(ee, [1 9], 1), SubSE(ee, [1 9], 1), 'b.', 'LineWidth', 2);
    end
    set(s1,'ylim',[10 22]);
    %set(s1,'xlim',[1 9]);
    set(s1,'xlim',[0.5 9.5]);
    if(ee<6)
        set(s1, 'XTick', 1:2:9);
    else
        set(s1, 'XTick', 3:2:7);
    end
    yline(16, 'k--', 'LineWidth', 2);
    switch ee
        case 1, title('Expt 1');
        case 2, title('Expt 2A');
        case 3, title('Expt 2B');
        case 4, title('Expt 3A');
        case 5, title('Expt 3B');
        case 6, title('Expt 4');
    end

   % title(strcat('Experiment ', ' ', num2str(Expt_Num)));
    xlabel('Object Number'); ylabel('Grasp Location (cms)');

    if(ee==1)
        legend({'Orient 1', 'Orient 2', 'True CoM'})
    end

    fontsize(fig1, 15, "points");

    set(0, 'CurrentFigure', fig2)
    if(ee<6)
    s2 = subplot(2, 3, ee, 'Parent', fig2);
    p(ee) = errorbar(s2,1:2, SubMeans(ee, [1 9],1), SubSE(ee, [1 9],1));hold on;
    xlim([0 3]); ylim([10 22]);
    yline(16, 'k--');
    title(strcat('Experiment ', ' ', num2str(ee)));
    xlabel('Object Number'); ylabel('Grasp Location (cms)');
    set(gca,'XTickLabel',{[]; '1'; '9';[]})
    end
end %%% end expt loop
set(0, 'CurrentFigure', fig1);
s2 = subplot(2, 3, ee, 'Parent', fig1);
legend({'Orient 1, RH', 'Orient 2, RH', 'Orient 1, LH', 'Orient 2, LH'})
legend('Location','northeast')

biasFig = figure('name', 'Bias Summary');
subplot(1,2,1); hold on;
plot(2:8, squeeze(mean(bias28, 1)), '*-');hold on;
%%% biases from control expt %%%
plot([3 5 7], mean(bias28_4([3 5 7], 1), 1), 'k*-', 'LineWidth', 1);
plot([3 5 7], mean(bias28_4([3 5 7], 2), 1), 'ko--', 'LineWidth', 1);

xlim([1 9]); ylim([-1 2]);
yline(0, 'k--');
xlabel('Object Number'); ylabel('Bias cm');

subplot(1,2,2);
plot([1 9], squeeze(mean(bias19, 1)), '*-');hold on;
yline(0, 'k--'); hold on;
xlim([0 10]); ylim([-1 2]);
yline(0, 'k--');
xlabel('Object Number'); ylabel('Bias cm');
xticks([1 9])
%set(gca,'XTickValues', [1 9])
set(gca,'XTickLabel',{'1'; '9';})
legend({'Exp 1', 'Exp 2a', 'Exp 2a', 'Exp 3a', 'Exp 3b', 'Exp 4'})
legend('Location','northeast')


%%% 2 way ANOVA for object and orientation, expts 1-3
for ee=1:5
    ExptData = squeeze(AllGrasp(:, ee, :, :));
    %%% format data for 2 way ANOVA %%%
    anova_dat = [];
    anova_dat2 = [];
        %%% loop through levels of factor 2 (orientation), then subs, adding rows.
        %%% columns are levels of factor 1 (object)
        for(orient=1:2)
            for(ss=1:20)
                all_obs = squeeze(ExptData(ss, :, orient));
                all_obs2 = all_obs;
                for(ob=1:7)
                    value = all_obs(ob);
                    if(isnan(value))
                        all_obs(ob) = mean(all_obs, 'omitnan');
                    end
                end

                %anova_dat = [anova_dat; squeeze(ExptData(ss, :, orient))];
                anova_dat = [anova_dat; all_obs];
                anova_dat2 = [anova_dat2; all_obs2];
 
            end
        end
        ano = anova2(anova_dat, 20);
end


%%% 3 factor anova for expt 4
%%% organise data for SPSS, one row per subjects
%%% dimensions are sub, ob, orientation hand
E4Data = meanGrasp4(:, [3 5 7], :, :);
SPSS_dat = [];
for(ss=1:17)
    sub_data = [E4Data(ss, :, 1, 1) E4Data(ss, :, 1, 2) E4Data(ss, :, 2, 1) E4Data(ss, :, 2, 2)];
    SPSS_dat = [SPSS_dat; sub_data];
end
