function [Est_D, Norm_Like28] = getSubFit(ParSet, obI, MODEL)


global Nsim
global norm28
global norm28_2
global like28 % will be altered within fitting loop, but storage pre-declared
global Pos_edges
global Ntrials28

%%% get the estimated density of metal at each trial timepoint
    X = 0:Ntrials28-1; % assumes no learning on trials with objects 1 and 9
   
    if(MODEL.LSpace==1)
         Est_D = (ParSet.DensStart - ParSet.DensEnd) * exp(-ParSet.LearnRate * X) + ParSet.DensEnd;
    else
        Est_LogD = (ParSet.DensStart - ParSet.DensEnd) * exp(-ParSet.LearnRate * X) + ParSet.DensEnd;
        Est_D = exp(Est_LogD);
    end
  
    %%%% noise should be normally distributed in either regular space, or
    %%%% log space
    %%% convert the norm28 normal noise to have the mean and std dictated by
    %%% the exponential learning of density of metal
    %%% like 28 becomes the density estimates
    if(MODEL.LSpace==1)
        like28 = norm28*ParSet.RatSigma; % correct std
        like28 = like28 + Est_D'; % correct means
    else
        %%% in log space
        like28 = norm28*ParSet.RatSigma; % correct std
        like28 = like28 + Est_LogD'; % correct means
        %%% back to regular space
        like28 = exp(like28);
    end
    % Remove any values of Est_D <= 0 by setting to NaN. Need to adjust
    % NSims in calculation of probability (see below)
    like28(like28<=0) = NaN;

    % if Plot_Sims > 0
    %     figure('Name', 'DensityExp');
    %     plot(X, Est_D);
    % end

    %%%% convert the density estimates to CoM estimates
    %%%    TrueCoM(ii) = (MetalPos(ii)*MetalMass(ii) + PlasticPos(ii)*PlasticMass(ii))/(MetalMass(ii) + PlasticMass(ii));
    %%%% likelihood of CoM estimates
    like28 = (obI.Metal_Pos'.*obI.Metal_Len'.*like28 + obI.Plas_Pos'.*obI.Plas_Mass')./(obI.Metal_Len'.*like28 + obI.Plas_Mass');
    if min(like28(:))<=2 || max(like28(:))>=30
        fprintf('Min CoM = %f, Max Com = %f\n', min(like28(:)),max(like28(:)));
    end

    %%%% add the motor noise
    %%%% becomes likelihood of grasp locations
    %%% estimate population std from sample std (i.e. the N-1 normalisation)

    like28 = like28 + ParSet.MotSigma*norm28_2;

%%%% histcounts doesn't seem to work on matrices.. doh!
    for(tt=1:Ntrials28)
        index = find(isnan(like28(tt, :)));
        [Count(tt, :), ~] = histcounts(like28(tt, :), Pos_edges);
        Norm_Like28(tt, :) = Count(tt, :)./(Nsim-length(index));
    end

end