function [results_File] = get_resultsFileName(Expt_Num, FIT_BOTH, MODEL)

global FREE
global FIXED
global STORED

if(FIT_BOTH)
    results_File = strcat('E', num2str(Expt_Num), 'AB');
else
    results_File = strcat('E', num2str(Expt_Num));
end
if(MODEL.LSpace==1)
    results_File = strcat(results_File, '_Reg');
else
    results_File = strcat(results_File, '_Log');
end
if(MODEL.DensStart(1)==FREE)
    results_File = strcat(results_File, '_DS');
end
if(MODEL.DensStart(1)==STORED)
    results_File = strcat(results_File, '_DSS');
end
if(MODEL.DensEnd(1) ==FREE)
    results_File = strcat(results_File, '_DE');
end
if(MODEL.MotSigma(1) ==FREE)
    results_File = strcat(results_File, '_MoS');
end
if(MODEL.RatSigma(1) ==FREE)
    results_File = strcat(results_File, '_RaS');
end
if(MODEL.OrB(1)==FREE)
    results_File = strcat(results_File, '_OB');
end
if((MODEL.OrB(1)==FIXED) & MODEL.OrB(2) > 0)
    results_File = strcat(results_File, '_OBF');
end
if((MODEL.LearnRate_B(1)==FREE))
    results_File = strcat(results_File, '_LR2');
end
if(isfield(MODEL, 'MotSigma_B'))
    if((MODEL.MotSigma_B(1)==FREE))
        results_File = strcat(results_File, '_MoS2');
    end
end
results_File = strcat(results_File, '.mat');


end