function [NegLike] = likelihood_PPT3(parameters, sub_dat28, sub_dat19, obI, MODEL, FIT_BOTH)

%%% sub_dat28 in THIRD column has grasping positions as indices for bins
%%% updated to version 2 to include subfunctions for better generalisation
%%% updated to version 3 to allow fitting parts A and B, in which case
% sub_dat18, sub_dat19 and obI will be twice the size

global Ntrials28
global Plot_Sims
global Pos_vals
global Ntrials19
global DensStartSub
global STORED


%%%% these bits added to do noisy (log) density ratio
global Pos_incr

%%%% set parameter values
ParSet = setParams(parameters, MODEL, sub_dat19, 1);  % 1 for Part A

if(MODEL.DensStart(1)==STORED) % from file
    ParSet.DensStart = DensStartSub;
    if(MODEL.LSpace==1)
        ParSet.DensStart = DensStartSub;
    else
        ParSet.DensStart = log(DensStartSub);
    end
end

%%% check all params within limits
WITHIN_LIMITS = 1;
if(MODEL.LSpace==1 && (ParSet.DensStart<=0 || ParSet.DensEnd<=0))
    WITHIN_LIMITS = 0;
end
if(ParSet.MotSigma<0 || ParSet.RatSigma<0)
    WITHIN_LIMITS = 0;
end
if(ParSet.LearnRate<0)
    WITHIN_LIMITS=0;
end
if(FIT_BOTH)
    %%%% fit part B %%%
    %%% set params for part B
    ParSetB = setParams(parameters, MODEL, sub_dat19, 2);
    if(ParSetB.LearnRate<0)
        WITHIN_LIMITS=0;
    end
end

if(WITHIN_LIMITS==0)
    NegLike = inf;
else

    %%%% get fit from parameters
    obI_A.Metal_Len = obI.Metal_Len(1:Ntrials28);
    obI_A.Metal_Pos = obI.Metal_Pos(1:Ntrials28);
    obI_A.Plas_Pos = obI.Plas_Pos(1:Ntrials28);
    obI_A.Plas_Mass = obI.Plas_Mass(1:Ntrials28);
    [Est_D, Norm_Like28] = getSubFit(ParSet, obI_A, MODEL);

    for(tt=1:Ntrials28)
        Probs28(tt) = Norm_Like28(tt, sub_dat28(tt, 3));
    end

    Probs19 = Pos_incr*normpdf(sub_dat19(1:Ntrials19, 2), 16, ParSet.MotSigma);

    if(FIT_BOTH)
        %%%% fit part B %%%
        %%% set params for part B
        %%% need to set start point of density estimation
        if(MODEL.LSpace==1) % regular
            ParSetB.DensStart = Est_D(Ntrials28);
        else % log space
            ParSetB.DensStart = log(Est_D(Ntrials28));
        end
        obI_B.Metal_Len = obI.Metal_Len(Ntrials28+1:end);
        obI_B.Metal_Pos = obI.Metal_Pos(Ntrials28+1:end);
        obI_B.Plas_Pos = obI.Plas_Pos(Ntrials28+1:end);
        obI_B.Plas_Mass = obI.Plas_Mass(Ntrials28+1:end);
        [Est_D_B, Norm_Like28_B] = getSubFit(ParSetB, obI_B, MODEL);

        %%% already doing probability of all 19 trials together
        %%% add probability for 28 trials
        for(tt=1:Ntrials28)
            Probs28(Ntrials28+tt) = Norm_Like28_B(tt, sub_dat28(tt+Ntrials28, 3));
        end
        Probs19_B = Pos_incr*normpdf(sub_dat19(Ntrials19+1:end, 2), 16, ParSetB.MotSigma);
        Probs19 = [Probs19; Probs19_B];
    end

    
    if (min(Probs19)==0)
        fprintf('Subject Probs19 not fit');
    end

    log_probs = log([Probs28 Probs19']);
    PLOTS = 0;
    if(PLOTS)
        figure('Name', 'likelihoods')
        for(tt=1:35)
            subplot(5, 7, tt)
            plot(Pos_vals, Norm_Like28(tt, :));
            hold on
            xline(Pos_vals(sub_dat28(tt, 3)), 'r', LineWidth=2);
        end
    end

    NegLike = -sum(log_probs);


end
Plot_Sims = Plot_Sims-1;
end

